/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.NativeImageBuildRunner;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.deployment.util.ProcessUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public abstract class NativeImageBuildContainerRunner
extends NativeImageBuildRunner {
    private static final Logger log = Logger.getLogger(NativeImageBuildContainerRunner.class);
    private final NativeConfig nativeConfig;
    protected final NativeConfig.ContainerRuntime containerRuntime;
    private final String[] baseContainerRuntimeArgs;
    protected final String outputPath;

    public NativeImageBuildContainerRunner(NativeConfig nativeConfig, Path outputDir) {
        this.nativeConfig = nativeConfig;
        this.containerRuntime = nativeConfig.containerRuntime.orElseGet(NativeImageBuildContainerRunner::detectContainerRuntime);
        log.infof("Using %s to run the native image builder", (Object)this.containerRuntime.getExecutableName());
        this.baseContainerRuntimeArgs = new String[]{"--env", "LANG=C"};
        this.outputPath = outputDir == null ? null : outputDir.toAbsolutePath().toString();
    }

    @Override
    public void setup(boolean processInheritIODisabled) {
        if (this.containerRuntime == NativeConfig.ContainerRuntime.DOCKER || this.containerRuntime == NativeConfig.ContainerRuntime.PODMAN) {
            log.info((Object)("Checking image status " + this.nativeConfig.builderImage));
            Process pullProcess = null;
            try {
                ProcessBuilder pb = new ProcessBuilder(Arrays.asList(this.containerRuntime.getExecutableName(), "pull", this.nativeConfig.builderImage));
                pullProcess = ProcessUtil.launchProcess(pb, processInheritIODisabled);
                pullProcess.waitFor();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed to pull builder image " + this.nativeConfig.builderImage, e);
            }
            finally {
                if (pullProcess != null) {
                    pullProcess.destroy();
                }
            }
        }
    }

    @Override
    protected String[] getGraalVMVersionCommand(List<String> args) {
        return this.buildCommand("run", Collections.singletonList("--rm"), args);
    }

    @Override
    protected String[] getBuildCommand(List<String> args) {
        return this.buildCommand("run", this.getContainerRuntimeBuildArgs(), args);
    }

    protected List<String> getContainerRuntimeBuildArgs() {
        ArrayList<String> containerRuntimeArgs = new ArrayList<String>();
        this.nativeConfig.containerRuntimeOptions.ifPresent(containerRuntimeArgs::addAll);
        if (this.nativeConfig.debugBuildProcess && this.nativeConfig.publishDebugBuildProcessPort) {
            containerRuntimeArgs.add("--publish=5005:5005");
        }
        return containerRuntimeArgs;
    }

    protected String[] buildCommand(String dockerCmd, List<String> containerRuntimeArgs, List<String> command) {
        return (String[])Stream.of(Stream.of(this.containerRuntime.getExecutableName()), Stream.of(dockerCmd), Stream.of(this.baseContainerRuntimeArgs), containerRuntimeArgs.stream(), Stream.of(this.nativeConfig.builderImage), command.stream()).flatMap(Function.identity()).toArray(String[]::new);
    }

    private static NativeConfig.ContainerRuntime detectContainerRuntime() {
        String dockerVersionOutput = NativeImageBuildContainerRunner.getVersionOutputFor(NativeConfig.ContainerRuntime.DOCKER);
        boolean dockerAvailable = dockerVersionOutput.contains("Docker version");
        String podmanVersionOutput = NativeImageBuildContainerRunner.getVersionOutputFor(NativeConfig.ContainerRuntime.PODMAN);
        boolean podmanAvailable = podmanVersionOutput.startsWith("podman version");
        if (dockerAvailable) {
            if (dockerVersionOutput.equals(podmanVersionOutput)) {
                return NativeConfig.ContainerRuntime.PODMAN;
            }
            return NativeConfig.ContainerRuntime.DOCKER;
        }
        if (podmanAvailable) {
            return NativeConfig.ContainerRuntime.PODMAN;
        }
        throw new IllegalStateException("No container runtime was found to run the native image builder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionOutputFor(NativeConfig.ContainerRuntime containerRuntime) {
        Process versionProcess = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(containerRuntime.getExecutableName(), "--version").redirectErrorStream(true);
            versionProcess = pb.start();
            versionProcess.waitFor();
            String string = new String(FileUtil.readFileContents(versionProcess.getInputStream()), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException | InterruptedException e) {
            log.debugf((Throwable)e, "Failure to read version output from %s", (Object)containerRuntime.getExecutableName());
            String string = "";
            return string;
        }
        finally {
            if (versionProcess != null) {
                versionProcess.destroy();
            }
        }
    }
}

