/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.resolver.maven.workspace.UnresolvedVersionException;
import io.quarkus.bootstrap.resolver.maven.workspace.WorkspaceLoader;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultSourceDir;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GAV;
import io.quarkus.maven.dependency.ResolvedArtifactDependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.DirectoryPathTree;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathList;
import io.quarkus.paths.PathTree;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class LocalProject {
    public static final String PROJECT_GROUPID = "${project.groupId}";
    private static final String PROJECT_BASEDIR = "${project.basedir}";
    private static final String PROJECT_BUILD_DIR = "${project.build.directory}";
    static final String PROJECT_OUTPUT_DIR = "${project.build.outputDirectory}";
    public static final String POM_XML = "pom.xml";
    private final Model rawModel;
    private final ArtifactKey key;
    private String version;
    private final Path dir;
    private final LocalWorkspace workspace;
    final List<LocalProject> modules = new ArrayList<LocalProject>(0);
    private final ModelBuildingResult modelBuildingResult;
    private WorkspaceModule module;

    public static LocalProject load(Path path) throws BootstrapMavenException {
        return LocalProject.load(path, true);
    }

    public static LocalProject load(Path path, boolean required) throws BootstrapMavenException {
        Path pom = LocalProject.locateCurrentProjectPom(path, required);
        if (pom == null) {
            return null;
        }
        try {
            return new LocalProject(LocalProject.readModel(pom), null);
        }
        catch (UnresolvedVersionException e) {
            return LocalProject.loadWorkspace(pom);
        }
    }

    public static LocalProject loadWorkspace(Path path) throws BootstrapMavenException {
        return LocalProject.loadWorkspace(path, true);
    }

    public static LocalProject loadWorkspace(Path path, boolean required) throws BootstrapMavenException {
        try {
            return new WorkspaceLoader(null, path.normalize().toAbsolutePath()).load();
        }
        catch (Exception e) {
            if (required) {
                throw e;
            }
            return null;
        }
    }

    public static LocalProject loadWorkspace(BootstrapMavenContext ctx) throws BootstrapMavenException {
        Path currentProjectPom = ctx.getCurrentProjectPomOrNull();
        if (currentProjectPom == null) {
            return null;
        }
        Path rootProjectBaseDir = ctx.getRootProjectBaseDir();
        WorkspaceLoader wsLoader = new WorkspaceLoader(ctx, currentProjectPom);
        if (rootProjectBaseDir != null && !rootProjectBaseDir.equals(currentProjectPom.getParent())) {
            wsLoader.setWorkspaceRootPom(rootProjectBaseDir.resolve(POM_XML));
        }
        return wsLoader.load();
    }

    static final Model readModel(Path pom) throws BootstrapMavenException {
        try {
            Model model = ModelUtils.readModel(pom);
            model.setPomFile(pom.toFile());
            return model;
        }
        catch (IOException e) {
            throw new BootstrapMavenException("Failed to read " + pom, e);
        }
    }

    static Path locateCurrentProjectPom(Path path, boolean required) throws BootstrapMavenException {
        for (Path p = path; p != null; p = p.getParent()) {
            Path pom = p.resolve(POM_XML);
            if (!Files.exists(pom, new LinkOption[0])) continue;
            return pom;
        }
        if (required) {
            throw new BootstrapMavenException("Failed to locate project pom.xml for " + path);
        }
        return null;
    }

    LocalProject(ModelBuildingResult modelBuildingResult, LocalWorkspace workspace) {
        this.rawModel = modelBuildingResult.getRawModel();
        Model effectiveModel = modelBuildingResult.getEffectiveModel();
        this.key = ArtifactKey.ga((String)effectiveModel.getGroupId(), (String)effectiveModel.getArtifactId());
        this.version = effectiveModel.getVersion();
        this.dir = effectiveModel.getProjectDirectory().toPath();
        this.modelBuildingResult = modelBuildingResult;
        this.workspace = workspace;
        if (workspace != null) {
            workspace.addProject(this, this.rawModel.getPomFile().lastModified());
        }
    }

    LocalProject(Model rawModel, LocalWorkspace workspace) throws BootstrapMavenException {
        this.modelBuildingResult = null;
        this.rawModel = rawModel;
        this.dir = rawModel.getProjectDirectory().toPath();
        this.workspace = workspace;
        this.key = ArtifactKey.ga((String)ModelUtils.getGroupId(rawModel), (String)rawModel.getArtifactId());
        String rawVersion = ModelUtils.getRawVersion(rawModel);
        boolean rawVersionIsUnresolved = ModelUtils.isUnresolvedVersion(rawVersion);
        String string = this.version = rawVersionIsUnresolved ? ModelUtils.resolveVersion(rawVersion, rawModel) : rawVersion;
        if (workspace != null) {
            workspace.addProject(this, rawModel.getPomFile().lastModified());
            if (rawVersionIsUnresolved && this.version != null) {
                workspace.setResolvedVersion(this.version);
            }
        } else if (this.version == null && rawVersionIsUnresolved) {
            throw UnresolvedVersionException.forGa(this.key.getGroupId(), this.key.getArtifactId(), rawVersion);
        }
    }

    public LocalProject getLocalParent() {
        if (this.workspace == null) {
            return null;
        }
        Parent parent = this.rawModel.getParent();
        if (parent == null) {
            return null;
        }
        return this.workspace.getProject(parent.getGroupId(), parent.getArtifactId());
    }

    public String getGroupId() {
        return this.key.getGroupId();
    }

    public String getArtifactId() {
        return this.key.getArtifactId();
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        if (this.workspace != null) {
            this.version = this.workspace.getResolvedVersion();
        }
        if (this.version == null) {
            throw UnresolvedVersionException.forGa(this.key.getGroupId(), this.key.getArtifactId(), ModelUtils.getRawVersion(this.rawModel));
        }
        return this.version;
    }

    public Path getDir() {
        return this.dir;
    }

    public Path getOutputDir() {
        return this.modelBuildingResult == null ? this.resolveRelativeToBaseDir(LocalProject.configuredBuildDir(this, build -> build.getDirectory()), "target") : Paths.get(this.modelBuildingResult.getEffectiveModel().getBuild().getDirectory(), new String[0]);
    }

    public Path getCodeGenOutputDir() {
        return this.getOutputDir().resolve("generated-sources");
    }

    public Path getClassesDir() {
        return this.modelBuildingResult == null ? this.resolveRelativeToBuildDir(LocalProject.configuredBuildDir(this, build -> build.getOutputDirectory()), "classes") : Paths.get(this.modelBuildingResult.getEffectiveModel().getBuild().getOutputDirectory(), new String[0]);
    }

    public Path getTestClassesDir() {
        return this.modelBuildingResult == null ? this.resolveRelativeToBuildDir(LocalProject.configuredBuildDir(this, build -> build.getTestOutputDirectory()), "test-classes") : Paths.get(this.modelBuildingResult.getEffectiveModel().getBuild().getTestOutputDirectory(), new String[0]);
    }

    public Path getSourcesSourcesDir() {
        return this.modelBuildingResult == null ? this.resolveRelativeToBaseDir(LocalProject.configuredBuildDir(this, build -> build.getSourceDirectory()), "src/main/java") : Paths.get(this.modelBuildingResult.getEffectiveModel().getBuild().getSourceDirectory(), new String[0]);
    }

    public Path getTestSourcesSourcesDir() {
        return this.resolveRelativeToBaseDir(LocalProject.configuredBuildDir(this, build -> build.getTestSourceDirectory()), "src/test/java");
    }

    public Path getSourcesDir() {
        return this.getSourcesSourcesDir().getParent();
    }

    public PathCollection getResourcesSourcesDirs() {
        List resources;
        List list = resources = this.rawModel.getBuild() == null ? Collections.emptyList() : this.rawModel.getBuild().getResources();
        if (resources.isEmpty()) {
            return PathList.of((Path[])new Path[]{this.resolveRelativeToBaseDir(null, "src/main/resources")});
        }
        return PathList.from((Iterable)resources.stream().map(FileSet::getDirectory).map(resourcesDir -> this.resolveRelativeToBaseDir((String)resourcesDir, "src/main/resources")).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public PathCollection getTestResourcesSourcesDirs() {
        List resources;
        List list = resources = this.rawModel.getBuild() == null ? Collections.emptyList() : this.rawModel.getBuild().getTestResources();
        if (resources.isEmpty()) {
            return PathList.of((Path[])new Path[]{this.resolveRelativeToBaseDir(null, "src/test/resources")});
        }
        return PathList.from((Iterable)resources.stream().map(FileSet::getDirectory).map(resourcesDir -> this.resolveRelativeToBaseDir((String)resourcesDir, "src/test/resources")).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public ModelBuildingResult getModelBuildingResult() {
        return this.modelBuildingResult;
    }

    public Model getRawModel() {
        return this.rawModel;
    }

    public LocalWorkspace getWorkspace() {
        return this.workspace;
    }

    public ArtifactKey getKey() {
        return this.key;
    }

    public String getPackaging() {
        return this.modelBuildingResult == null ? this.rawModel.getPackaging() : this.modelBuildingResult.getEffectiveModel().getPackaging();
    }

    public ResolvedDependency getAppArtifact() {
        return this.getAppArtifact(this.getPackaging());
    }

    public ResolvedDependency getAppArtifact(String extension) {
        return new ResolvedArtifactDependency(this.key.getGroupId(), this.key.getArtifactId(), "", extension, this.getVersion(), (PathCollection)null);
    }

    public Path resolveRelativeToBaseDir(String path) {
        return this.resolveRelativeToBaseDir(path, null);
    }

    Path resolveRelativeToBaseDir(String path, String defaultPath) {
        return this.dir.resolve(path == null ? defaultPath : LocalProject.stripProjectBasedirPrefix(path, PROJECT_BASEDIR));
    }

    private Path resolveRelativeToBuildDir(String path, String defaultPath) {
        return this.getOutputDir().resolve(path == null ? defaultPath : LocalProject.stripProjectBasedirPrefix(path, PROJECT_BUILD_DIR));
    }

    static String stripProjectBasedirPrefix(String path, String expr) {
        return path.startsWith(expr) ? path.substring(expr.length() + 1) : path;
    }

    private static String configuredBuildDir(LocalProject project, Function<Build, String> f) {
        String dir;
        String string = dir = project.rawModel.getBuild() == null ? null : f.apply(project.rawModel.getBuild());
        while (dir == null && (project = project.getLocalParent()) != null) {
            if (project.rawModel.getBuild() == null) continue;
            dir = f.apply(project.rawModel.getBuild());
        }
        return dir;
    }

    public WorkspaceModule toWorkspaceModule() {
        if (this.module != null) {
            return this.module;
        }
        WorkspaceModule.Mutable moduleBuilder = WorkspaceModule.builder().setModuleId((WorkspaceModuleId)new GAV(this.key.getGroupId(), this.key.getArtifactId(), this.getVersion())).setModuleDir(this.dir).setBuildDir(this.getOutputDir());
        Build build = (this.modelBuildingResult == null ? this.getRawModel() : this.modelBuildingResult.getEffectiveModel()).getBuild();
        if (build != null && !build.getPlugins().isEmpty()) {
            for (Plugin plugin : build.getPlugins()) {
                if (!plugin.getArtifactId().equals("maven-jar-plugin")) continue;
                for (PluginExecution e : plugin.getExecutions()) {
                    DefaultArtifactSources src = null;
                    if (e.getGoals().contains("jar")) {
                        src = this.processJarPluginExecutionConfig(e, false);
                    } else if (e.getGoals().contains("test-jar")) {
                        src = this.processJarPluginExecutionConfig(e, true);
                    }
                    if (src == null) continue;
                    moduleBuilder.addArtifactSources((ArtifactSources)src);
                }
            }
        }
        if (!moduleBuilder.hasMainSources()) {
            moduleBuilder.addArtifactSources((ArtifactSources)new DefaultArtifactSources("", Collections.singletonList(new DefaultSourceDir(this.getSourcesSourcesDir(), this.getClassesDir())), this.collectMainResources(null)));
        }
        if (!moduleBuilder.hasTestSources()) {
            moduleBuilder.addArtifactSources((ArtifactSources)new DefaultArtifactSources("tests", Collections.singletonList(new DefaultSourceDir(this.getTestSourcesSourcesDir(), this.getTestClassesDir())), this.collectTestResources(null)));
        }
        moduleBuilder.setBuildFile(this.getRawModel().getPomFile().toPath());
        moduleBuilder.setDependencyConstraints(this.getRawModel().getDependencyManagement() == null ? Collections.emptyList() : this.toArtifactDependencies(this.getRawModel().getDependencyManagement().getDependencies()));
        Model model = this.modelBuildingResult == null ? this.rawModel : this.modelBuildingResult.getEffectiveModel();
        moduleBuilder.setDependencies(this.toArtifactDependencies(model.getDependencies()));
        this.module = moduleBuilder.build();
        return this.module;
    }

    private List<io.quarkus.maven.dependency.Dependency> toArtifactDependencies(List<Dependency> rawModelDeps) {
        if (rawModelDeps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<io.quarkus.maven.dependency.Dependency> directDeps = new ArrayList<io.quarkus.maven.dependency.Dependency>(rawModelDeps.size());
        for (Dependency d : rawModelDeps) {
            directDeps.add((io.quarkus.maven.dependency.Dependency)new ArtifactDependency(this.resolveElementValue(d.getGroupId()), this.resolveElementValue(d.getArtifactId()), this.resolveElementValue(d.getClassifier()), this.resolveElementValue(d.getType()), this.resolveElementValue(d.getVersion()), d.getScope(), d.isOptional()));
        }
        return directDeps;
    }

    private String resolveElementValue(String elementValue) {
        if (elementValue == null || elementValue.isEmpty() || !elementValue.startsWith("${") || !elementValue.endsWith("}")) {
            return elementValue;
        }
        return this.rawModel.getProperties().getProperty(elementValue.substring(2, elementValue.length() - 1), elementValue);
    }

    private DefaultArtifactSources processJarPluginExecutionConfig(PluginExecution e, boolean test) {
        Object config = e.getConfiguration();
        if (config == null || !(config instanceof Xpp3Dom)) {
            return null;
        }
        Xpp3Dom dom = (Xpp3Dom)config;
        List<String> includes = this.collectChildValues(dom.getChild("includes"));
        List<String> excludes = this.collectChildValues(dom.getChild("excludes"));
        if (includes == null && excludes == null) {
            return null;
        }
        PathFilter filter = new PathFilter(includes, excludes);
        String classifier = LocalProject.getClassifier(dom, test);
        List<DefaultSourceDir> sources = Collections.singletonList(new DefaultSourceDir((PathTree)new DirectoryPathTree(test ? this.getTestSourcesSourcesDir() : this.getSourcesSourcesDir()), (PathTree)new DirectoryPathTree(test ? this.getTestClassesDir() : this.getClassesDir(), filter), Collections.emptyMap()));
        Collection<SourceDir> resources = test ? this.collectTestResources(filter) : this.collectMainResources(filter);
        return new DefaultArtifactSources(classifier, sources, resources);
    }

    private List<String> collectChildValues(Xpp3Dom container) {
        if (container == null) {
            return null;
        }
        Xpp3Dom[] excludeElements = container.getChildren();
        ArrayList<String> list = new ArrayList<String>(excludeElements.length);
        for (Xpp3Dom child : container.getChildren()) {
            list.add(child.getValue());
        }
        return list;
    }

    private static String getClassifier(Xpp3Dom dom, boolean test) {
        Xpp3Dom classifier = dom.getChild("classifier");
        return classifier == null ? (test ? "tests" : "") : classifier.getValue();
    }

    private Collection<SourceDir> collectMainResources(PathFilter filter) {
        List resources = this.rawModel.getBuild() == null ? Collections.emptyList() : this.rawModel.getBuild().getResources();
        Path classesDir = this.getClassesDir();
        if (resources.isEmpty()) {
            return Collections.singletonList(new DefaultSourceDir((PathTree)new DirectoryPathTree(this.resolveRelativeToBaseDir(null, "src/main/resources")), (PathTree)new DirectoryPathTree(classesDir, filter), Collections.emptyMap()));
        }
        ArrayList<SourceDir> sourceDirs = new ArrayList<SourceDir>(resources.size());
        for (Resource r : resources) {
            sourceDirs.add((SourceDir)new DefaultSourceDir((PathTree)new DirectoryPathTree(this.resolveRelativeToBaseDir(r.getDirectory(), "src/main/resources")), (PathTree)new DirectoryPathTree(r.getTargetPath() == null ? classesDir : classesDir.resolve(LocalProject.stripProjectBasedirPrefix(r.getTargetPath(), PROJECT_OUTPUT_DIR)), filter), Collections.emptyMap()));
        }
        return sourceDirs;
    }

    private Collection<SourceDir> collectTestResources(PathFilter filter) {
        List resources = this.rawModel.getBuild() == null ? Collections.emptyList() : this.rawModel.getBuild().getTestResources();
        Path testClassesDir = this.getTestClassesDir();
        if (resources.isEmpty()) {
            return Collections.singletonList(new DefaultSourceDir((PathTree)new DirectoryPathTree(this.resolveRelativeToBaseDir(null, "src/test/resources")), (PathTree)new DirectoryPathTree(testClassesDir, filter), Collections.emptyMap()));
        }
        ArrayList<SourceDir> sourceDirs = new ArrayList<SourceDir>(resources.size());
        for (Resource r : resources) {
            sourceDirs.add((SourceDir)new DefaultSourceDir((PathTree)new DirectoryPathTree(this.resolveRelativeToBaseDir(r.getDirectory(), "src/test/resources")), (PathTree)new DirectoryPathTree(r.getTargetPath() == null ? testClassesDir : testClassesDir.resolve(LocalProject.stripProjectBasedirPrefix(r.getTargetPath(), PROJECT_OUTPUT_DIR)), filter), Collections.emptyMap()));
        }
        return sourceDirs;
    }
}

