/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.paths.EmptyPathTree;
import io.quarkus.paths.MultiRootPathTree;
import io.quarkus.paths.PathTree;
import java.util.ArrayList;
import java.util.Collection;

public interface ArtifactSources {
    public String getClassifier();

    public Collection<SourceDir> getSourceDirs();

    public Collection<SourceDir> getResourceDirs();

    default public boolean isOutputAvailable() {
        for (SourceDir src : this.getSourceDirs()) {
            if (!src.isOutputAvailable()) continue;
            return true;
        }
        for (SourceDir src : this.getResourceDirs()) {
            if (!src.isOutputAvailable()) continue;
            return true;
        }
        return false;
    }

    default public PathTree getOutputTree() {
        PathTree outputTree;
        Collection<SourceDir> sourceDirs = this.getSourceDirs();
        Collection<SourceDir> resourceDirs = this.getResourceDirs();
        ArrayList<PathTree> trees = new ArrayList<PathTree>(sourceDirs.size() + resourceDirs.size());
        for (SourceDir src : sourceDirs) {
            outputTree = src.getOutputTree();
            if (outputTree == null || outputTree.isEmpty() || trees.contains(outputTree)) continue;
            trees.add(outputTree);
        }
        for (SourceDir src : resourceDirs) {
            outputTree = src.getOutputTree();
            if (outputTree == null || outputTree.isEmpty() || trees.contains(outputTree)) continue;
            trees.add(outputTree);
        }
        if (trees.isEmpty()) {
            return EmptyPathTree.getInstance();
        }
        if (trees.size() == 1) {
            return (PathTree)trees.get(0);
        }
        return new MultiRootPathTree(trees.toArray(new PathTree[0]));
    }
}

