/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.workspace.ProcessedSources;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class DefaultProcessedSources
implements ProcessedSources,
Serializable {
    private final File srcDir;
    private final File destinationDir;
    private final Map<Object, Object> data;

    public DefaultProcessedSources(File srcDir, File destinationDir) {
        this(srcDir, destinationDir, Collections.emptyMap());
    }

    public DefaultProcessedSources(File srcDir, File destinationDir, Map<Object, Object> data) {
        this.srcDir = srcDir;
        this.destinationDir = destinationDir;
        this.data = data;
    }

    @Override
    public File getSourceDir() {
        return this.srcDir;
    }

    @Override
    public File getDestinationDir() {
        return this.destinationDir;
    }

    @Override
    public <T> T getValue(Object key, Class<T> type) {
        Object o = this.data.get(key);
        return o == null ? null : (T)type.cast(o);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.destinationDir, this.srcDir);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultProcessedSources other = (DefaultProcessedSources)obj;
        return Objects.equals(this.data, other.data) && Objects.equals(this.destinationDir, other.destinationDir) && Objects.equals(this.srcDir, other.srcDir);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.srcDir).append(" -> ").append(this.destinationDir);
        if (!this.data.isEmpty()) {
            Iterator<Map.Entry<Object, Object>> i = this.data.entrySet().iterator();
            Map.Entry<Object, Object> e = i.next();
            buf.append(" ").append(e.getKey()).append("=").append(e.getValue());
            while (i.hasNext()) {
                e = i.next();
                buf.append(",").append(e.getKey()).append("=").append(e.getValue());
            }
        }
        return buf.toString();
    }
}

