/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class KnownCompatibleBeanArchiveBuildItem
extends MultiBuildItem {
    final Set<Reason> reasons;
    final String groupId;
    final String artifactId;
    final String classifier;

    @Deprecated
    public KnownCompatibleBeanArchiveBuildItem(String groupId, String artifactId) {
        this(groupId, artifactId, "");
    }

    @Deprecated
    public KnownCompatibleBeanArchiveBuildItem(String groupId, String artifactId, String classifier) {
        this(groupId, artifactId, classifier, Set.of(Reason.BEANS_XML_ALL));
    }

    private KnownCompatibleBeanArchiveBuildItem(String groupId, String artifactId, String classifier, Set<Reason> reasons) {
        Objects.requireNonNull(groupId, "groupId must be set");
        Objects.requireNonNull(artifactId, "artifactId must be set");
        Objects.requireNonNull(classifier, "classifier must be set");
        if (reasons.isEmpty()) {
            throw new IllegalStateException("KnownCompatibleBeanArchiveBuildItem.Builder needs to declare at least one compatibility reason. Artifact with following coordinates had no reason associated: " + groupId + ":" + artifactId);
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier;
        this.reasons = reasons;
    }

    public static Builder builder(String groupId, String artifactId) {
        return new Builder(groupId, artifactId);
    }

    public static enum Reason {
        BEANS_XML_ALL,
        SPECIALIZES_ANNOTATION;

    }

    public static class Builder {
        private final String groupId;
        private final String artifactId;
        private final Set<Reason> reasons;
        private String classifier;

        private Builder(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = "";
            this.reasons = new HashSet<Reason>();
        }

        public Builder setClassifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder addReason(Reason reason) {
            this.reasons.add(reason);
            return this;
        }

        public KnownCompatibleBeanArchiveBuildItem build() {
            return new KnownCompatibleBeanArchiveBuildItem(this.groupId, this.artifactId, this.classifier, this.reasons);
        }
    }
}

