/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DuplexChannel;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.WebConnection;

public class WebConnectionImpl
extends CombinedChannelDuplexHandler<InboundHandler, OutboundHandler>
implements WebConnection {
    private final LinkedBlockingDeque<ByteBuf> dataQueue = new LinkedBlockingDeque();
    private static final ByteBuf LAST = Unpooled.buffer((int)0);
    private ChannelHandlerContext context;
    private final UpgradeInputStream inputStream = new UpgradeInputStream();
    private final UpgradeOutputStream outputStream = new UpgradeOutputStream();
    private boolean writeClosed;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.init((ChannelInboundHandler)new InboundHandler(), (ChannelOutboundHandler)new OutboundHandler());
        ctx.read();
        super.handlerAdded(ctx);
        this.context = ctx;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public void close() throws Exception {
    }

    class UpgradeInputStream
    extends ServletInputStream {
        private volatile ReadListener readListener;
        private volatile boolean canNotifyListener;

        UpgradeInputStream() {
        }

        void notifyData() {
            if (this.readListener != null && this.canNotifyListener) {
                this.invokeListener();
            }
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            boolean ret = !WebConnectionImpl.this.dataQueue.isEmpty();
            this.canNotifyListener = !ret;
            return ret;
        }

        public void setReadListener(ReadListener r) {
            this.readListener = r;
            this.invokeListener();
        }

        void invokeListener() {
            try {
                this.readListener.onDataAvailable();
            }
            catch (IOException e) {
                this.readListener.onError((Throwable)e);
            }
        }

        public int read() throws IOException {
            byte[] buf = new byte[1];
            int res = this.read(buf);
            if (res == -1) {
                return -1;
            }
            return buf[0];
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.readListener != null && WebConnectionImpl.this.dataQueue.isEmpty()) {
                throw new IllegalStateException();
            }
            try {
                ByteBuf buf = (ByteBuf)WebConnectionImpl.this.dataQueue.take();
                if (buf == LAST) {
                    if (this.readListener != null) {
                        WebConnectionImpl.this.context.executor().execute(new Runnable(){

                            @Override
                            public void run() {
                                UpgradeInputStream.this.notifyEnd();
                            }
                        });
                    }
                    return -1;
                }
                int toRead = Math.min(len, buf.readableBytes());
                buf.readBytes(b, off, toRead);
                if (buf.isReadable()) {
                    WebConnectionImpl.this.dataQueue.addFirst(buf);
                } else {
                    buf.release();
                }
                return toRead;
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public void close() throws IOException {
            ((DuplexChannel)WebConnectionImpl.this.context.channel()).shutdownOutput();
        }

        public void notifyEnd() {
            try {
                this.readListener.onAllDataRead();
            }
            catch (IOException e) {
                this.readListener.onError((Throwable)e);
            }
        }
    }

    class UpgradeOutputStream
    extends ServletOutputStream {
        private volatile WriteListener writeListener;

        UpgradeOutputStream() {
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener w) {
            this.writeListener = w;
            try {
                w.onWritePossible();
            }
            catch (IOException e) {
                this.writeListener.onError((Throwable)e);
            }
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            ByteBuf buf = Unpooled.buffer((int)len);
            buf.writeBytes(b, off, len);
            try {
                WebConnectionImpl.this.context.writeAndFlush((Object)buf).get();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void close() throws IOException {
            ((DuplexChannel)WebConnectionImpl.this.context.channel()).shutdownOutput();
        }
    }

    class InboundHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        InboundHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            msg.retain();
            WebConnectionImpl.this.dataQueue.add(msg);
            WebConnectionImpl.this.inputStream.notifyData();
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            super.channelReadComplete(ctx);
            WebConnectionImpl.this.dataQueue.add(LAST);
            WebConnectionImpl.this.inputStream.notifyData();
        }
    }

    class OutboundHandler
    extends ChannelOutboundHandlerAdapter {
        OutboundHandler() {
        }
    }
}

