/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.InvokeKind;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.Descs;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.Util;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Const
extends Expr,
Constable {
    public ConstantDesc desc();

    public static Const of(Constable constable) {
        return ConstImpl.of(constable);
    }

    public static Const of(ConstantDesc constantDesc) {
        return ConstImpl.of(constantDesc);
    }

    public static Const of(DynamicConstantDesc<?> dcd) {
        return ConstImpl.of(dcd);
    }

    public static Const ofNull(ClassDesc type) {
        return ConstImpl.ofNull(type);
    }

    public static Const ofNull(Class<?> type) {
        return ConstImpl.ofNull(type);
    }

    public static Const ofDefault(ClassDesc type) {
        return switch (type.descriptorString()) {
            case "B" -> Const.of((byte)0);
            case "S" -> Const.of((short)0);
            case "C" -> Const.of('\u0000');
            case "I" -> Const.of(0);
            case "J" -> Const.of(0L);
            case "F" -> Const.of(0.0f);
            case "D" -> Const.of(0.0);
            case "Z" -> Const.of(false);
            case "V" -> Const.ofVoid();
            default -> Const.ofNull(type);
        };
    }

    public static Const ofDefault(Class<?> type) {
        return Const.ofDefault(Util.classDesc(type));
    }

    public static Const of(ClassDesc value) {
        return ConstImpl.of(value);
    }

    public static Const of(Class<?> value) {
        return ConstImpl.of(value);
    }

    public static Const of(VarHandle.VarHandleDesc value) {
        return ConstImpl.of(value);
    }

    public static Const of(Enum.EnumDesc<?> value) {
        return ConstImpl.of(value);
    }

    public static Const of(Byte value) {
        return ConstImpl.of(value);
    }

    public static Const of(byte value) {
        return ConstImpl.of(value);
    }

    public static Const of(Short value) {
        return ConstImpl.of(value);
    }

    public static Const of(short value) {
        return ConstImpl.of(value);
    }

    public static Const of(Character value) {
        return ConstImpl.of(value);
    }

    public static Const of(char value) {
        return ConstImpl.of(value);
    }

    public static Const of(Integer value) {
        return ConstImpl.of(value);
    }

    public static Const of(int value) {
        return ConstImpl.of(value);
    }

    public static Const of(Long value) {
        return ConstImpl.of(value);
    }

    public static Const of(long value) {
        return ConstImpl.of(value);
    }

    public static Const of(Float value) {
        return ConstImpl.of(value);
    }

    public static Const of(float value) {
        return ConstImpl.of(value);
    }

    public static Const of(Double value) {
        return ConstImpl.of(value);
    }

    public static Const of(double value) {
        return ConstImpl.of(value);
    }

    public static Const of(Boolean value) {
        return ConstImpl.of(value);
    }

    public static Const of(boolean value) {
        return ConstImpl.of(value);
    }

    public static Const of(int value, TypeKind typeKind) {
        return ConstImpl.of(value, typeKind);
    }

    public static Const of(long value, TypeKind typeKind) {
        return ConstImpl.of(value, typeKind);
    }

    public static Const of(float value, TypeKind typeKind) {
        return ConstImpl.of(value, typeKind);
    }

    public static Const of(double value, TypeKind typeKind) {
        return ConstImpl.of(value, typeKind);
    }

    public static Const of(String value) {
        return ConstImpl.of(value);
    }

    public static Const ofVoid() {
        return ConstImpl.ofVoid();
    }

    public static Const ofFieldVarHandle(FieldDesc desc) {
        return ConstImpl.ofFieldVarHandle(desc);
    }

    public static Const ofStaticFieldVarHandle(FieldDesc desc) {
        return ConstImpl.ofStaticFieldVarHandle(desc);
    }

    public static Const ofStaticFinalField(FieldDesc desc) {
        return ConstImpl.ofStaticFinalField(desc);
    }

    public static Const ofArrayVarHandle(ClassDesc arrayType) {
        return ConstImpl.ofArrayVarHandle(arrayType);
    }

    public static Const ofInvoke(Const methodHandle, List<Const> args) {
        return ConstImpl.ofInvoke(methodHandle, args);
    }

    public static Const ofInvoke(Const methodHandle, Const ... args) {
        return ConstImpl.ofInvoke(methodHandle, List.of(args));
    }

    public static Const of(MethodHandleDesc desc) {
        return ConstImpl.of(desc);
    }

    public static Const ofMethodHandle(InvokeKind kind, MethodDesc desc) {
        return ConstImpl.ofMethodHandle(kind, desc);
    }

    public static Const ofConstructorMethodHandle(ConstructorDesc desc) {
        return ConstImpl.ofConstructorMethodHandle(desc);
    }

    public static Const ofFieldSetterMethodHandle(FieldDesc desc) {
        return ConstImpl.ofFieldSetterMethodHandle(desc);
    }

    public static Const ofFieldGetterMethodHandle(FieldDesc desc) {
        return ConstImpl.ofFieldGetterMethodHandle(desc);
    }

    public static Const ofStaticFieldSetterMethodHandle(FieldDesc desc) {
        return ConstImpl.ofStaticFieldSetterMethodHandle(desc);
    }

    public static Const ofStaticFieldGetterMethodHandle(FieldDesc desc) {
        return ConstImpl.ofStaticFieldGetterMethodHandle(desc);
    }

    public static Const of(MethodTypeDesc desc) {
        return ConstImpl.of(desc);
    }

    public static Const of(List<?> items) {
        int size = (items = List.copyOf(items)).size();
        if (size > 254) {
            throw new IllegalArgumentException("List is too big (%d elements, max is 254)".formatted(size));
        }
        return Const.ofInvoke(Const.ofMethodHandle(InvokeKind.STATIC, size > 10 ? Descs.MD_List.of_array : Descs.MD_List.of_n(size)), Const.consts(items));
    }

    public static Const of(Set<?> items) {
        int size = (items = Set.copyOf(items)).size();
        if (size > 254) {
            throw new IllegalArgumentException("Set is too big (%d elements, max is 254)".formatted(size));
        }
        return Const.ofInvoke(Const.ofMethodHandle(InvokeKind.STATIC, size > 10 ? Descs.MD_Set.of_array : Descs.MD_Set.of_n(size)), Const.consts(items));
    }

    public static Const of(Map<?, ?> items) {
        int size = (items = Map.copyOf(items)).size();
        if (size > 254) {
            throw new IllegalArgumentException("Map is too big (%d elements, max is 254)".formatted(size));
        }
        if (size <= 10) {
            Const[] args = (Const[])items.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).map(Const::of).toArray(Const[]::new);
            return Const.ofInvoke(Const.ofMethodHandle(InvokeKind.STATIC, Descs.MD_Map.of_n(size)), args);
        }
        Const[] args = (Const[])items.entrySet().stream().map(Const::of).toArray(Const[]::new);
        return Const.ofInvoke(Const.ofMethodHandle(InvokeKind.STATIC, Descs.MD_Map.ofEntries), args);
    }

    public static Const of(Map.Entry<?, ?> entry) {
        return Const.ofInvoke(Const.ofMethodHandle(InvokeKind.STATIC, Descs.MD_Map.entry), Const.of(entry.getKey()), Const.of(entry.getValue()));
    }

    private static Const of(Object any) {
        if (any instanceof ConstantDesc) {
            ConstantDesc cd = (ConstantDesc)any;
            return Const.of(cd);
        }
        if (any instanceof Constable) {
            Constable c = (Constable)any;
            return Const.of(c);
        }
        throw Const.wrongType(any);
    }

    private static Const[] consts(Collection<?> items) {
        return (Const[])items.stream().map(Const::of).toArray(Const[]::new);
    }

    private static IllegalArgumentException wrongType(Object object) {
        return new IllegalArgumentException("Given object %s is not a valid constant".formatted(object));
    }
}

