/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableDecorator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.RuntimeTypeCreator;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

public class DecoratorGenerator
extends BeanGenerator {
    protected static final String FIELD_NAME_DECORATED_TYPES = "decoratedTypes";
    protected static final String FIELD_NAME_DELEGATE_TYPE = "delegateType";
    static final String ABSTRACT_IMPL_SUFFIX = "_Impl";

    public DecoratorGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Map<BeanInfo, String> beanToGeneratedName, Predicate<DotName> injectionPointAnnotationsPredicate) {
        super(annotationLiterals, applicationClassPredicate, privateMembers, generateSources, reflectionRegistration, existingClasses, beanToGeneratedName, injectionPointAnnotationsPredicate, Collections.emptyList());
    }

    void precomputeGeneratedName(DecoratorInfo decorator) {
        ClassInfo decoratorClass = decorator.getTarget().get().asClass();
        String baseName = decoratorClass.name().withoutPackagePrefix();
        String targetPackage = DotNames.packagePrefix(decorator.getProviderType().name());
        String generatedName = DecoratorGenerator.generatedNameFromTarget(targetPackage, baseName, "_Bean");
        this.beanToGeneratedName.put(decorator, generatedName);
        this.beanToGeneratedBaseName.put(decorator, baseName);
    }

    Collection<ResourceOutput.Resource> generate(DecoratorInfo decorator) {
        String baseName = (String)this.beanToGeneratedBaseName.get(decorator);
        String generatedName = (String)this.beanToGeneratedName.get(decorator);
        String targetPackage = DotNames.packagePrefix(decorator.getProviderType().name());
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(decorator.getBeanClass()) || decorator.isForceApplicationClass();
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.DECORATOR_BEAN : null, this.generateSources);
        Gizmo gizmo = DecoratorGenerator.gizmo(classOutput);
        this.generateDecorator(gizmo, decorator, generatedName, baseName, targetPackage, isApplicationClass);
        return classOutput.getResources();
    }

    private void generateDecorator(Gizmo gizmo, DecoratorInfo decorator, String generatedName, String baseName, String targetPackage, boolean isApplicationClass) {
        ClassInfo decoratorClass = decorator.getTarget().get().asClass();
        gizmo.class_(generatedName, cc -> {
            cc.implements_(InjectableDecorator.class);
            cc.implements_(Supplier.class);
            org.jboss.jandex.Type providerType = decorator.getProviderType();
            if (decorator.isAbstract()) {
                String generatedImplName = this.generateAbstractDecoratorImplementation(gizmo, baseName, targetPackage, decorator, decoratorClass);
                providerType = ClassType.create((String)generatedImplName);
            }
            FieldDesc beanTypesField = cc.field("types", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Set.class);
            });
            FieldDesc decoratedTypesField = cc.field(FIELD_NAME_DECORATED_TYPES, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Set.class);
            });
            FieldDesc delegateTypeField = cc.field(FIELD_NAME_DELEGATE_TYPE, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Type.class);
            });
            FieldDesc delegateQualifiersField = !decorator.getDelegateInjectionPoint().hasDefaultedQualifier() ? cc.field("qualifiers", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Set.class);
            }) : null;
            HashMap<InjectionPointInfo, FieldDesc> injectionPointToProviderField = new HashMap<InjectionPointInfo, FieldDesc>();
            this.generateProviderFields(decorator, (ClassCreator)cc, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderField, Map.of(), Map.of());
            this.generateConstructor(decorator, (ClassCreator)cc, beanTypesField, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderField, delegateQualifiersField, decoratedTypesField, delegateTypeField);
            this.generateCreate((ClassCreator)cc, decorator, new BeanGenerator.ProviderType(providerType), baseName, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderField, null, null, targetPackage, isApplicationClass);
            if (decorator.hasDestroyLogic()) {
                this.generateDestroy((ClassCreator)cc, decorator, Map.of(), isApplicationClass, baseName, targetPackage);
            }
            this.generateSupplierGet((ClassCreator)cc);
            this.generateInjectableReferenceProviderGet(decorator, (ClassCreator)cc, baseName);
            this.generateGetIdentifier((ClassCreator)cc, decorator);
            this.generateGetTypes(beanTypesField, (ClassCreator)cc);
            this.generateGetPriority((ClassCreator)cc, decorator);
            this.generateGetBeanClass((ClassCreator)cc, decorator);
            this.generateGetInjectionPoints((ClassCreator)cc, decorator);
            this.generateEquals((ClassCreator)cc, decorator);
            this.generateHashCode((ClassCreator)cc, decorator);
            this.generateToString((ClassCreator)cc);
            this.generateGetDecoratedTypes((ClassCreator)cc, decoratedTypesField);
            this.generateGetDelegateType((ClassCreator)cc, delegateTypeField);
            this.generateGetDelegateQualifiers((ClassCreator)cc, delegateQualifiersField);
        });
    }

    private void generateConstructor(DecoratorInfo decorator, ClassCreator cc, FieldDesc beanTypesField, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderField, FieldDesc delegateQualifiersField, FieldDesc decoratedTypesField, FieldDesc delegateTypeField) {
        super.generateConstructor(cc, decorator, beanTypesField, null, null, null, injectionPointToProviderField, Map.of(), Map.of(), bc -> {
            LocalVar delegateType;
            if (delegateQualifiersField != null) {
                LocalVar delegateQualifiers = bc.localVar("delegateQualifiers", bc.new_(HashSet.class));
                for (AnnotationInstance delegateQualifier : decorator.getDelegateQualifiers()) {
                    ClassInfo delegateQualifierClass = decorator.getDeployment().getQualifier(delegateQualifier.name());
                    bc.withSet((Expr)delegateQualifiers).add(this.annotationLiterals.create((BlockCreator)bc, delegateQualifierClass, delegateQualifier));
                }
                bc.set((Assignable)cc.this_().field(delegateQualifiersField), (Expr)delegateQualifiers);
            }
            LocalVar tccl = bc.localVar("tccl", bc.invokeVirtual(MethodDescs.THREAD_GET_TCCL, bc.currentThread()));
            RuntimeTypeCreator rttc = RuntimeTypeCreator.of(bc).withTCCL((Var)tccl);
            LocalVar decoratedTypes = bc.localVar(FIELD_NAME_DECORATED_TYPES, bc.new_(HashSet.class));
            for (org.jboss.jandex.Type decoratedType : decorator.getDecoratedTypes()) {
                try {
                    bc.withSet((Expr)decoratedTypes).add((Expr)rttc.create(decoratedType));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Unable to construct type for " + String.valueOf(decorator) + ": " + e.getMessage());
                }
            }
            bc.set((Assignable)cc.this_().field(decoratedTypesField), (Expr)decoratedTypes);
            try {
                delegateType = rttc.create(decorator.getDelegateType());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to construct type for " + String.valueOf(decorator) + ": " + e.getMessage());
            }
            bc.set((Assignable)cc.this_().field(delegateTypeField), (Expr)delegateType);
        });
    }

    static boolean isAbstractDecoratorImpl(BeanInfo bean, String providerTypeName) {
        return bean.isDecorator() && ((DecoratorInfo)bean).isAbstract() && providerTypeName.endsWith(ABSTRACT_IMPL_SUFFIX);
    }

    private String generateAbstractDecoratorImplementation(Gizmo gizmo, String baseName, String targetPackage, DecoratorInfo decorator, ClassInfo decoratorClass) {
        IndexView index = decorator.getDeployment().getBeanArchiveIndex();
        String generatedImplName = DecoratorGenerator.generatedNameFromTarget(targetPackage, baseName, ABSTRACT_IMPL_SUFFIX);
        gizmo.class_(generatedImplName, cc -> {
            cc.extends_(Jandex2Gizmo.classDescOf((ClassInfo)decoratorClass));
            FieldDesc delegateField = cc.field("impl$delegate", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Object.class);
            });
            MethodInfo decoratorConstructor = decoratorClass.firstMethod("<init>");
            cc.constructor(mc -> {
                ArrayList<ParamVar> superParams = new ArrayList<ParamVar>();
                int paramIdx = 0;
                for (MethodParameterInfo parameter : decoratorConstructor.parameters()) {
                    String paramName = parameter.name();
                    org.jboss.jandex.Type paramType = parameter.type();
                    superParams.add(mc.parameter((String)(paramName != null ? paramName : "param" + paramIdx), Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)paramType)));
                    ++paramIdx;
                }
                ParamVar creationalContext = mc.parameter("creationalContext", CreationalContext.class);
                mc.body(bc -> {
                    bc.invokeSpecial(Jandex2Gizmo.constructorDescOf((MethodInfo)decoratorConstructor), (Expr)cc.this_(), superParams);
                    bc.set((Assignable)cc.this_().field(delegateField), bc.invokeStatic(MethodDescs.DECORATOR_DELEGATE_PROVIDER_GET, (Expr)creationalContext));
                    bc.return_();
                });
            });
            ArrayList<MethodInfo> decoratorMethods = new ArrayList<MethodInfo>();
            ArrayDeque<ClassInfo> worklist = new ArrayDeque<ClassInfo>();
            HashSet<DotName> seen = new HashSet<DotName>();
            worklist.add(decoratorClass);
            while (!worklist.isEmpty()) {
                ClassInfo clazz = (ClassInfo)worklist.poll();
                if (!seen.add(clazz.name())) continue;
                for (MethodInfo decoratorMethod : clazz.methods()) {
                    if (decoratorMethod.isAbstract() || !Modifier.isPublic(decoratorMethod.flags())) continue;
                    decoratorMethods.add(decoratorMethod);
                }
                if (!clazz.isInterface() && clazz.superName() != null) {
                    worklist.add(index.getClassByName(clazz.superName()));
                }
                for (DotName iface : clazz.interfaceNames()) {
                    worklist.add(index.getClassByName(iface));
                }
            }
            HashSet<MethodDesc> abstractMethods = new HashSet<MethodDesc>();
            HashMap<ClassMethodDesc, MethodDesc> bridgeMethods = new HashMap<ClassMethodDesc, MethodDesc>();
            for (org.jboss.jandex.Type type : decorator.getDecoratedTypes()) {
                ClassInfo decoratedInterface = index.getClassByName(type.name());
                if (decoratedInterface == null) {
                    throw new IllegalStateException("Decorated type not found in the bean archive index: " + String.valueOf(type));
                }
                boolean isDecoratedInterfaceGeneric = !decoratedInterface.typeParameters().isEmpty();
                Map<String, org.jboss.jandex.Type> resolvedTypeParameters = Types.resolveDecoratedTypeParams(decoratedInterface, decorator);
                for (MethodInfo method : decoratedInterface.methods()) {
                    ClassMethodDesc resolvedMethodDesc;
                    if (Methods.skipForDelegateSubclass(method)) continue;
                    MethodDesc methodDesc = Jandex2Gizmo.methodDescOf((MethodInfo)method);
                    if (isDecoratedInterfaceGeneric && (Methods.containsTypeVariableParameter(method) || Types.containsTypeVariable(method.returnType()))) {
                        List<org.jboss.jandex.Type> paramTypes = Types.getResolvedParameters(decoratedInterface, resolvedTypeParameters, method, index);
                        org.jboss.jandex.Type returnType = Types.resolveTypeParam(method.returnType(), resolvedTypeParameters, index);
                        ClassDesc[] paramTypesArray = new ClassDesc[paramTypes.size()];
                        for (int i = 0; i < paramTypesArray.length; ++i) {
                            paramTypesArray[i] = Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)paramTypes.get(i));
                        }
                        resolvedMethodDesc = ClassMethodDesc.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)method.declaringClass()), (String)method.name(), (MethodTypeDesc)MethodTypeDesc.of(Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)returnType), paramTypesArray));
                    } else {
                        resolvedMethodDesc = null;
                    }
                    boolean include = true;
                    for (MethodInfo decoratorMethod : decoratorMethods) {
                        if (decoratorMethod.isConstructor() || decoratorMethod.isStaticInitializer() || !Methods.descriptorMatches(Jandex2Gizmo.methodDescOf((MethodInfo)decoratorMethod), methodDesc)) continue;
                        include = false;
                        break;
                    }
                    if (!include) continue;
                    abstractMethods.add(methodDesc);
                    if (resolvedMethodDesc == null) continue;
                    bridgeMethods.put(resolvedMethodDesc, methodDesc);
                }
            }
            for (MethodDesc methodDesc : abstractMethods) {
                cc.method(methodDesc, mc -> {
                    ArrayList<ParamVar> params = new ArrayList<ParamVar>(abstractMethod.parameterCount());
                    for (int i = 0; i < abstractMethod.parameterCount(); ++i) {
                        params.add(mc.parameter("param" + i, i));
                    }
                    mc.body(bc -> bc.return_(bc.invokeInterface(abstractMethod, (Expr)cc.this_().field(delegateField), params)));
                });
            }
            for (Map.Entry entry : bridgeMethods.entrySet()) {
                MethodDesc bridgeMethod = (MethodDesc)entry.getKey();
                MethodDesc targetMethod = (MethodDesc)entry.getValue();
                cc.method(bridgeMethod, mc -> {
                    ArrayList<ParamVar> params = new ArrayList<ParamVar>(bridgeMethod.parameterCount());
                    for (int i = 0; i < bridgeMethod.parameterCount(); ++i) {
                        params.add(mc.parameter("param" + i, i));
                    }
                    mc.body(bc -> {
                        Expr result = bc.invokeVirtual((MethodDesc)ClassMethodDesc.of((ClassDesc)cc.type(), (String)targetMethod.name(), (MethodTypeDesc)MethodTypeDesc.of(targetMethod.returnType(), (ClassDesc[])targetMethod.parameterTypes().toArray(ClassDesc[]::new))), (Expr)cc.this_(), params);
                        bc.return_(bc.cast(result, bridgeMethod.returnType()));
                    });
                });
            }
        });
        return generatedImplName;
    }

    protected void generateGetDecoratedTypes(ClassCreator cc, FieldDesc decoratedTypes) {
        cc.method("getDecoratedTypes", mc -> {
            mc.returning(Set.class);
            mc.body(bc -> bc.return_((Expr)cc.this_().field(decoratedTypes)));
        });
    }

    protected void generateGetDelegateType(ClassCreator cc, FieldDesc delegateType) {
        cc.method("getDelegateType", mc -> {
            mc.returning(Type.class);
            mc.body(bc -> bc.return_((Expr)cc.this_().field(delegateType)));
        });
    }

    protected void generateGetDelegateQualifiers(ClassCreator cc, FieldDesc qualifiersField) {
        if (qualifiersField != null) {
            cc.method("getDelegateQualifiers", mc -> {
                mc.returning(Set.class);
                mc.body(bc -> bc.return_((Expr)cc.this_().field(qualifiersField)));
            });
        }
    }
}

