/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.ResourceImpl;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo2.ClassOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ResourceClassOutput
implements ClassOutput {
    private static final Function<String, ResourceOutput.Resource.SpecialType> NO_SPECIAL_TYPE = cn -> null;
    private final List<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
    private final boolean applicationClass;
    private final Function<String, ResourceOutput.Resource.SpecialType> specialTypeFunction;

    public ResourceClassOutput(boolean applicationClass, boolean generateSource) {
        this(applicationClass, NO_SPECIAL_TYPE, generateSource);
    }

    public ResourceClassOutput(boolean applicationClass, Function<String, ResourceOutput.Resource.SpecialType> specialTypeFunction, boolean generateSource) {
        this.applicationClass = applicationClass;
        this.specialTypeFunction = specialTypeFunction;
    }

    public void write(String name, byte[] data) {
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        String className = name.replace('/', '.');
        this.resources.add(ResourceImpl.javaClass(name, data, this.specialTypeFunction.apply(className), this.applicationClass, null));
    }

    List<ResourceOutput.Resource> getResources() {
        return this.resources;
    }
}

