/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanInfo;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class BeanStream
implements Iterable<BeanInfo> {
    private Stream<BeanInfo> stream;

    public BeanStream(Collection<BeanInfo> beans) {
        this.stream = Objects.requireNonNull(beans, "Beans collection is null").stream();
    }

    public BeanStream withScope(Class<? extends Annotation> scope) {
        return this.withScope(DotName.createSimple((String)scope.getName()));
    }

    public BeanStream withScope(DotName scopeName) {
        this.stream = this.stream.filter((? super T bean) -> bean.getScope().getDotName().equals((Object)scopeName));
        return this;
    }

    public BeanStream withBeanType(Class<?> beanType) {
        return this.withBeanType(DotName.createSimple((String)beanType.getName()));
    }

    public BeanStream withBeanType(DotName beanTypeName) {
        this.stream = this.stream.filter((? super T bean) -> bean.getTypes().stream().anyMatch(t -> t.name().equals((Object)beanTypeName)));
        return this;
    }

    public BeanStream withBeanType(Type beanType) {
        this.stream = this.stream.filter((? super T bean) -> bean.getTypes().stream().anyMatch(t -> t.equals((Object)beanType)));
        return this;
    }

    public BeanStream withBeanClass(Class<?> beanClass) {
        return this.withBeanClass(DotName.createSimple((String)beanClass.getName()));
    }

    public BeanStream matchBeanTypes(Predicate<Set<Type>> predicate) {
        this.stream = this.stream.filter((? super T bean) -> predicate.test(bean.getTypes()));
        return this;
    }

    public BeanStream withTarget() {
        this.stream = this.stream.filter((? super T bean) -> bean.getTarget().isPresent());
        return this;
    }

    public BeanStream withBeanClass(DotName beanClass) {
        this.stream = this.stream.filter((? super T bean) -> bean.getBeanClass().equals((Object)beanClass));
        return this;
    }

    @SafeVarargs
    public final BeanStream withQualifier(Class<? extends Annotation> ... qualifiers) {
        if (qualifiers.length == 1) {
            return this.withQualifier(DotName.createSimple((String)qualifiers[0].getName()));
        }
        return this.withQualifier((DotName[])Arrays.stream(qualifiers).map(q -> DotName.createSimple((String)q.getName())).toArray(DotName[]::new));
    }

    public BeanStream withQualifier(DotName ... qualifierNames) {
        this.stream = qualifierNames.length == 1 ? this.stream.filter((? super T bean) -> bean.getQualifiers().stream().anyMatch(q -> q.name().equals((Object)qualifierNames[0]))) : this.stream.filter((? super T bean) -> bean.getQualifiers().stream().anyMatch(q -> {
            for (DotName qualifierName : qualifierNames) {
                if (!q.name().equals((Object)qualifierName)) continue;
                return true;
            }
            return false;
        }));
        return this;
    }

    public BeanStream withName(String name) {
        this.stream = this.stream.filter((? super T bean) -> name.equals(bean.getName()));
        return this;
    }

    public BeanStream withName() {
        this.stream = this.stream.filter((? super T bean) -> bean.getName() != null);
        return this;
    }

    public BeanStream withAroundInvokeInterceptor() {
        this.stream = this.stream.filter(BeanInfo::hasAroundInvokeInterceptors);
        return this;
    }

    public BeanStream withLifecycleInterceptor() {
        this.stream = this.stream.filter(BeanInfo::hasLifecycleInterceptors);
        return this;
    }

    public Optional<BeanInfo> findByIdentifier(String id) {
        return this.stream.filter((? super T bean) -> id.equals(bean.getIdentifier())).findFirst();
    }

    public BeanStream producers() {
        this.stream = this.stream.filter(BeanInfo::isProducer);
        return this;
    }

    public BeanStream producerMethods() {
        this.stream = this.stream.filter(BeanInfo::isProducerMethod);
        return this;
    }

    public BeanStream producerFields() {
        this.stream = this.stream.filter(BeanInfo::isProducerField);
        return this;
    }

    public BeanStream classBeans() {
        this.stream = this.stream.filter(BeanInfo::isClassBean);
        return this;
    }

    public BeanStream syntheticBeans() {
        this.stream = this.stream.filter(BeanInfo::isSynthetic);
        return this;
    }

    public BeanStream namedBeans() {
        this.stream = this.stream.filter((? super T bean) -> bean.getName() != null);
        return this;
    }

    public BeanStream defaultBeans() {
        this.stream = this.stream.filter(BeanInfo::isDefaultBean);
        return this;
    }

    public BeanStream alternativeBeans() {
        this.stream = this.stream.filter(BeanInfo::isAlternative);
        return this;
    }

    public BeanStream assignableTo(Type requiredType, AnnotationInstance ... requiredQualifiers) {
        this.stream = this.stream.filter((? super T bean) -> bean.isAssignableTo(requiredType, requiredQualifiers));
        return this;
    }

    public BeanStream filter(Predicate<BeanInfo> predicate) {
        this.stream = this.stream.filter(predicate);
        return this;
    }

    public List<BeanInfo> collect() {
        return this.stream.collect(Collectors.toList());
    }

    public Stream<BeanInfo> stream() {
        return this.stream;
    }

    public boolean isEmpty() {
        return this.stream.count() == 0L;
    }

    @Override
    public Iterator<BeanInfo> iterator() {
        return this.stream.iterator();
    }

    public Optional<BeanInfo> firstResult() {
        return this.stream.findFirst();
    }

    public <R, A> R collect(Collector<BeanInfo, A, R> collector) {
        return this.stream.collect(collector);
    }
}

