/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralGenerator;
import io.quarkus.arc.processor.FieldDescs;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

public class AnnotationLiteralProcessor {
    private static final String ANNOTATION_LITERAL_SUFFIX = "_ArcAnnotationLiteral";
    private final ComputingCache<CacheKey, AnnotationLiteralClassInfo> cache = new ComputingCache(key -> new AnnotationLiteralClassInfo(AnnotationLiteralProcessor.generateAnnotationLiteralClassName(key.annotationName()), applicationClassPredicate.test(key.annotationName()), key.annotationClass));
    private final IndexView beanArchiveIndex;

    AnnotationLiteralProcessor(IndexView beanArchiveIndex, Predicate<DotName> applicationClassPredicate) {
        this.beanArchiveIndex = Objects.requireNonNull(beanArchiveIndex);
    }

    boolean hasLiteralsToGenerate() {
        return !this.cache.isEmpty();
    }

    ComputingCache<CacheKey, AnnotationLiteralClassInfo> getCache() {
        return this.cache;
    }

    public Expr create(BlockCreator bc, ClassInfo annotationClass, AnnotationInstance annotationInstance) {
        if (!annotationInstance.runtimeVisible()) {
            throw new IllegalArgumentException("Annotation does not have @Retention(RUNTIME): " + String.valueOf(annotationInstance));
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException("Annotation class not available: " + String.valueOf(annotationInstance));
        }
        AnnotationLiteralClassInfo literal = (AnnotationLiteralClassInfo)this.cache.getValue((Object)new CacheKey(annotationClass));
        ClassDesc generatedClass = ClassDesc.of(literal.generatedClassName);
        if (literal.annotationMembers().isEmpty()) {
            return bc.getStaticField(FieldDesc.of((ClassDesc)generatedClass, (String)"INSTANCE", (ClassDesc)generatedClass));
        }
        Expr[] ctorArgs = new Expr[literal.annotationMembers().size()];
        int argIndex = 0;
        for (MethodInfo annotationMember : literal.annotationMembers()) {
            Expr valueExpr;
            AnnotationValue value = annotationInstance.value(annotationMember.name());
            if (value == null) {
                value = annotationMember.defaultValue();
            }
            if (value == null) {
                throw new IllegalStateException(String.format("Value is not set for %s.%s(). Most probably an older version of Jandex was used to index an application dependency. Make sure that Jandex 2.1+ is used.", annotationMember.declaringClass().name(), annotationMember.name()));
            }
            ctorArgs[argIndex] = valueExpr = this.loadValue(bc, literal, annotationMember, value);
            ++argIndex;
        }
        ConstructorDesc ctor = ConstructorDesc.of((ClassDesc)generatedClass, (ClassDesc[])((ClassDesc[])literal.annotationMembers().stream().map(it -> Jandex2Gizmo.classDescOf((Type)it.returnType())).toArray(ClassDesc[]::new)));
        return bc.new_(ctor, ctorArgs);
    }

    private Expr loadValue(BlockCreator bc, AnnotationLiteralClassInfo literal, MethodInfo annotationMember, AnnotationValue annotationMemberValue) {
        return switch (annotationMemberValue.kind()) {
            case AnnotationValue.Kind.BOOLEAN -> Const.of((boolean)annotationMemberValue.asBoolean());
            case AnnotationValue.Kind.BYTE -> Const.of((byte)annotationMemberValue.asByte());
            case AnnotationValue.Kind.SHORT -> Const.of((short)annotationMemberValue.asShort());
            case AnnotationValue.Kind.INTEGER -> Const.of((int)annotationMemberValue.asInt());
            case AnnotationValue.Kind.LONG -> Const.of((long)annotationMemberValue.asLong());
            case AnnotationValue.Kind.FLOAT -> Const.of((float)annotationMemberValue.asFloat());
            case AnnotationValue.Kind.DOUBLE -> Const.of((double)annotationMemberValue.asDouble());
            case AnnotationValue.Kind.CHARACTER -> Const.of((char)annotationMemberValue.asChar());
            case AnnotationValue.Kind.STRING -> Const.of((String)annotationMemberValue.asString());
            case AnnotationValue.Kind.ENUM -> {
                ClassDesc enumDesc = Jandex2Gizmo.classDescOf((DotName)annotationMemberValue.asEnumType());
                yield bc.getStaticField(FieldDesc.of((ClassDesc)enumDesc, (String)annotationMemberValue.asEnum(), (ClassDesc)enumDesc));
            }
            case AnnotationValue.Kind.CLASS -> {
                if (annotationMemberValue.equals((Object)annotationMember.defaultValue())) {
                    yield bc.getStaticField(FieldDesc.of((ClassDesc)ClassDesc.of(literal.generatedClassName), (String)AnnotationLiteralGenerator.defaultValueStaticFieldName(annotationMember), (ClassDesc)Jandex2Gizmo.classDescOf((Type)annotationMember.returnType())));
                }
                yield Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)annotationMemberValue.asClass()));
            }
            case AnnotationValue.Kind.NESTED -> {
                AnnotationInstance nestedAnnotation = annotationMemberValue.asNested();
                DotName annotationName = nestedAnnotation.name();
                ClassInfo annotationClass = this.beanArchiveIndex.getClassByName(annotationName);
                if (annotationClass == null) {
                    throw new IllegalStateException("Class of nested annotation " + String.valueOf(nestedAnnotation) + " missing");
                }
                yield this.create(bc, annotationClass, nestedAnnotation);
            }
            case AnnotationValue.Kind.ARRAY -> {
                AnnotationValue.Kind componentKind = annotationMemberValue.componentKind();
                switch (componentKind) {
                    case BOOLEAN: {
                        boolean[] booleanArray = annotationMemberValue.asBooleanArray();
                        Expr[] exprArray = new Expr[booleanArray.length];
                        for (int i = 0; i < booleanArray.length; ++i) {
                            exprArray[i] = Const.of((boolean)booleanArray[i]);
                        }
                        yield bc.newArray(Boolean.TYPE, exprArray);
                    }
                    case BYTE: {
                        byte[] byteArray = annotationMemberValue.asByteArray();
                        Expr[] exprArray = new Expr[byteArray.length];
                        for (int i = 0; i < byteArray.length; ++i) {
                            exprArray[i] = Const.of((byte)byteArray[i]);
                        }
                        yield bc.newArray(Byte.TYPE, exprArray);
                    }
                    case SHORT: {
                        short[] shortArray = annotationMemberValue.asShortArray();
                        Expr[] exprArray = new Expr[shortArray.length];
                        for (int i = 0; i < shortArray.length; ++i) {
                            exprArray[i] = Const.of((short)shortArray[i]);
                        }
                        yield bc.newArray(Short.TYPE, exprArray);
                    }
                    case INTEGER: {
                        int[] intArray = annotationMemberValue.asIntArray();
                        Expr[] exprArray = new Expr[intArray.length];
                        for (int i = 0; i < intArray.length; ++i) {
                            exprArray[i] = Const.of((int)intArray[i]);
                        }
                        yield bc.newArray(Integer.TYPE, exprArray);
                    }
                    case LONG: {
                        long[] longArray = annotationMemberValue.asLongArray();
                        Expr[] exprArray = new Expr[longArray.length];
                        for (int i = 0; i < longArray.length; ++i) {
                            exprArray[i] = Const.of((long)longArray[i]);
                        }
                        yield bc.newArray(Long.TYPE, exprArray);
                    }
                    case FLOAT: {
                        float[] floatArray = annotationMemberValue.asFloatArray();
                        Expr[] exprArray = new Expr[floatArray.length];
                        for (int i = 0; i < floatArray.length; ++i) {
                            exprArray[i] = Const.of((float)floatArray[i]);
                        }
                        yield bc.newArray(Float.TYPE, exprArray);
                    }
                    case DOUBLE: {
                        double[] doubleArray = annotationMemberValue.asDoubleArray();
                        Expr[] exprArray = new Expr[doubleArray.length];
                        for (int i = 0; i < doubleArray.length; ++i) {
                            exprArray[i] = Const.of((double)doubleArray[i]);
                        }
                        yield bc.newArray(Double.TYPE, exprArray);
                    }
                    case CHARACTER: {
                        char[] charArray = annotationMemberValue.asCharArray();
                        Expr[] exprArray = new Expr[charArray.length];
                        for (int i = 0; i < charArray.length; ++i) {
                            exprArray[i] = Const.of((char)charArray[i]);
                        }
                        yield bc.newArray(Character.TYPE, exprArray);
                    }
                    case STRING: {
                        String[] stringArray = annotationMemberValue.asStringArray();
                        Expr[] exprArray = new Expr[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            exprArray[i] = Const.of((String)stringArray[i]);
                        }
                        yield bc.newArray(String.class, exprArray);
                    }
                    case ENUM: {
                        String[] enumArray = annotationMemberValue.asEnumArray();
                        DotName[] enumTypeArray = annotationMemberValue.asEnumTypeArray();
                        LocalVar array = bc.localVar("array", bc.newEmptyArray(AnnotationLiteralProcessor.componentTypeOf(annotationMember), enumArray.length));
                        for (int i = 0; i < enumArray.length; ++i) {
                            ClassDesc classDesc = Jandex2Gizmo.classDescOf((DotName)enumTypeArray[i]);
                            FieldDesc fieldDesc = FieldDesc.of((ClassDesc)classDesc, (String)enumArray[i], (ClassDesc)classDesc);
                            bc.set(array.elem(i), bc.getStaticField(fieldDesc));
                        }
                        yield array;
                    }
                    case CLASS: {
                        if (annotationMemberValue.equals((Object)annotationMember.defaultValue())) {
                            yield bc.getStaticField(FieldDesc.of((ClassDesc)ClassDesc.of(literal.generatedClassName), (String)AnnotationLiteralGenerator.defaultValueStaticFieldName(annotationMember), (ClassDesc)Jandex2Gizmo.classDescOf((Type)annotationMember.returnType())));
                        }
                        Type[] classArray = annotationMemberValue.asClassArray();
                        LocalVar array = bc.localVar("array", bc.newEmptyArray(AnnotationLiteralProcessor.componentTypeOf(annotationMember), classArray.length));
                        for (int i = 0; i < classArray.length; ++i) {
                            bc.set(array.elem(i), Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)classArray[i])));
                        }
                        yield array;
                    }
                    case NESTED: {
                        AnnotationInstance[] nestedArray = annotationMemberValue.asNestedArray();
                        LocalVar array = bc.localVar("array", bc.newEmptyArray(AnnotationLiteralProcessor.componentTypeOf(annotationMember), nestedArray.length));
                        for (int i = 0; i < nestedArray.length; ++i) {
                            AnnotationInstance nestedAnnotation = nestedArray[i];
                            DotName annotationName = nestedAnnotation.name();
                            ClassInfo annotationClass = this.beanArchiveIndex.getClassByName(annotationName);
                            if (annotationClass == null) {
                                throw new IllegalStateException("Class of nested annotation " + String.valueOf(nestedAnnotation) + " missing");
                            }
                            Expr nestedAnnotationValue = this.create(bc, annotationClass, nestedAnnotation);
                            bc.set(array.elem(i), nestedAnnotationValue);
                        }
                        yield array;
                    }
                    case UNKNOWN: {
                        ClassDesc componentType = AnnotationLiteralProcessor.componentTypeOf(annotationMember);
                        if (ConstantDescs.CD_boolean.equals(componentType)) {
                            yield bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_BOOLEAN_ARRAY);
                        }
                        if (ConstantDescs.CD_byte.equals(componentType)) {
                            yield bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_BYTE_ARRAY);
                        }
                        if (ConstantDescs.CD_short.equals(componentType)) {
                            yield bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_SHORT_ARRAY);
                        }
                        if (ConstantDescs.CD_int.equals(componentType)) {
                            yield bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_INT_ARRAY);
                        }
                        if (ConstantDescs.CD_long.equals(componentType)) {
                            yield bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_LONG_ARRAY);
                        }
                        if (ConstantDescs.CD_float.equals(componentType)) {
                            yield bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_FLOAT_ARRAY);
                        }
                        if (ConstantDescs.CD_double.equals(componentType)) {
                            yield bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_DOUBLE_ARRAY);
                        }
                        if (ConstantDescs.CD_char.equals(componentType)) {
                            yield bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_CHAR_ARRAY);
                        }
                        if (ConstantDescs.CD_String.equals(componentType)) {
                            yield bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_STRING_ARRAY);
                        }
                        if (ConstantDescs.CD_Class.equals(componentType)) {
                            yield bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_CLASS_ARRAY);
                        }
                        yield bc.newEmptyArray(componentType, (Expr)Const.of((int)0));
                    }
                }
                throw new UnsupportedOperationException("Array component kind is " + String.valueOf(componentKind) + ", this should never happen");
            }
            default -> throw new UnsupportedOperationException("Unsupported value: " + String.valueOf(annotationMemberValue));
        };
    }

    private static ClassDesc componentTypeOf(MethodInfo annotationMember) {
        assert (annotationMember.returnType().kind() == Type.Kind.ARRAY);
        return Jandex2Gizmo.classDescOf((Type)annotationMember.returnType().asArrayType().componentType());
    }

    private static String componentType(MethodInfo method) {
        return AnnotationLiteralProcessor.componentTypeName(method).toString();
    }

    private static DotName componentTypeName(MethodInfo method) {
        ArrayType arrayType = method.returnType().asArrayType();
        return arrayType.constituent().name();
    }

    private static String generateAnnotationLiteralClassName(DotName annotationName) {
        boolean isJavaLang = annotationName.toString().startsWith("java.lang");
        String nameToUse = isJavaLang ? AbstractGenerator.DEFAULT_PACKAGE + annotationName.withoutPackagePrefix() : annotationName.toString();
        return nameToUse + ANNOTATION_LITERAL_SUFFIX;
    }

    static class CacheKey {
        final ClassInfo annotationClass;

        CacheKey(ClassInfo annotationClass) {
            this.annotationClass = annotationClass;
        }

        DotName annotationName() {
            return this.annotationClass.name();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.annotationClass.name(), cacheKey.annotationClass.name());
        }

        public int hashCode() {
            return Objects.hashCode(this.annotationClass.name());
        }
    }

    static class AnnotationLiteralClassInfo {
        final String generatedClassName;
        final boolean isApplicationClass;
        final ClassInfo annotationClass;

        AnnotationLiteralClassInfo(String generatedClassName, boolean isApplicationClass, ClassInfo annotationClass) {
            this.generatedClassName = generatedClassName;
            this.isApplicationClass = isApplicationClass;
            this.annotationClass = annotationClass;
        }

        DotName annotationName() {
            return this.annotationClass.name();
        }

        List<MethodInfo> annotationMembers() {
            ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
            for (MethodInfo method : this.annotationClass.unsortedMethods()) {
                if (method.name().equals("<clinit>") || method.name().equals("<init>")) continue;
                result.add(method);
            }
            return result;
        }
    }
}

