/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.javaoperatorsdk.operator.api.config.Utils;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Date;
import java.util.Properties;
import org.jboss.logging.Logger;

public class Version
extends io.javaoperatorsdk.operator.api.config.Version {
    private static final Logger log = Logger.getLogger((String)Version.class.getName());
    public static final String UNKNOWN = "unknown";
    private final String extensionVersion;
    private final String extensionBranch;
    private final String extensionCommit;
    private final String runtimeFabric8Version;
    private final Date extensionBuildTime;

    @RecordableConstructor
    public Version(String commit, Date builtTime, String extensionVersion, String extensionCommit, String extensionBranch, String runtimeFabric8Version, Date extensionBuildTime) {
        super(commit, builtTime);
        this.extensionVersion = extensionVersion;
        this.extensionBranch = extensionBranch;
        this.extensionCommit = extensionCommit;
        this.runtimeFabric8Version = runtimeFabric8Version;
        this.extensionBuildTime = extensionBuildTime;
    }

    public String getExtensionVersion() {
        return this.extensionVersion;
    }

    public String getExtensionBranch() {
        return this.extensionBranch;
    }

    public String getExtensionCommit() {
        return this.extensionCommit;
    }

    public Date getExtensionBuildTime() {
        return this.extensionBuildTime;
    }

    @IgnoreProperty
    public String getExtensionCompleteVersion() {
        String branch = UNKNOWN.equals(this.extensionBranch) ? " on branch: " + this.extensionBranch : "";
        return this.extensionVersion + " (commit: " + this.extensionCommit + branch + ") built on " + String.valueOf(this.extensionBuildTime);
    }

    @IgnoreProperty
    public String getSdkCompleteVersion() {
        return this.getSdkVersion() + " (commit: " + this.getCommit() + ") built on " + String.valueOf(this.getBuiltTime());
    }

    public String getQuarkusVersion() {
        return "3.23.2";
    }

    public String getRuntimeFabric8Version() {
        return this.runtimeFabric8Version;
    }

    public static Version loadFromProperties() {
        Date builtTime;
        io.javaoperatorsdk.operator.api.config.Version sdkVersion = Utils.VERSION;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("extension-version.properties");
        Properties properties = new Properties();
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                log.warnf("Couldn't load extension version information: {0}", (Object)e.getMessage());
            }
        } else {
            log.warn((Object)"Couldn't find extension-version.properties file. Default version information will be used.");
        }
        try {
            String time = properties.getProperty("git.build.time");
            builtTime = time != null ? Date.from(Instant.parse(time)) : Date.from(Instant.EPOCH);
        }
        catch (Exception e) {
            log.debug((Object)"Couldn't parse git.build.time property", (Throwable)e);
            builtTime = Date.from(Instant.EPOCH);
        }
        return new Version(sdkVersion.getCommit(), sdkVersion.getBuiltTime(), properties.getProperty("git.build.version", UNKNOWN), properties.getProperty("git.commit.id.abbrev", UNKNOWN), properties.getProperty("git.branch", UNKNOWN), io.fabric8.kubernetes.client.Version.clientVersion(), builtTime);
    }
}

