/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class TextFormat {
    static final Charset UTF8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");

    private TextFormat() {
    }

    static StringBuilder escapeBytes(ByteBuffer input) {
        int length = input.limit();
        StringBuilder builder = new StringBuilder(length);
        block12: for (int i = 0; i < length; ++i) {
            byte b = input.get(i);
            switch (b) {
                case 7: {
                    builder.append("\\007");
                    continue block12;
                }
                case 8: {
                    builder.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder.append("\\013");
                    continue block12;
                }
                case 92: {
                    builder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32) {
                        builder.append((char)b);
                        continue block12;
                    }
                    builder.append('\\');
                    builder.append((char)(48 + (b >>> 6 & 3)));
                    builder.append((char)(48 + (b >>> 3 & 7)));
                    builder.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder;
    }

    static ByteBuffer unescapeBytes(CharSequence input) {
        int pos = 0;
        int len = input.length();
        byte[] result = new byte[len];
        ByteBuffer buffer = ByteBuffer.wrap(result);
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (c == '\\') {
                if (i + 1 < len) {
                    int code;
                    if (TextFormat.isOctal(c = input.charAt(++i))) {
                        code = TextFormat.digitValue(c);
                        if (i + 1 < len && TextFormat.isOctal(input.charAt(i + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.charAt(++i));
                        }
                        if (i + 1 < len && TextFormat.isOctal(input.charAt(i + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.charAt(++i));
                        }
                        result[pos++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 'a': {
                            result[pos++] = 7;
                            break;
                        }
                        case 'b': {
                            result[pos++] = 8;
                            break;
                        }
                        case 'f': {
                            result[pos++] = 12;
                            break;
                        }
                        case 'n': {
                            result[pos++] = 10;
                            break;
                        }
                        case 'r': {
                            result[pos++] = 13;
                            break;
                        }
                        case 't': {
                            result[pos++] = 9;
                            break;
                        }
                        case 'v': {
                            result[pos++] = 11;
                            break;
                        }
                        case '\\': {
                            result[pos++] = 92;
                            break;
                        }
                        case '\'': {
                            result[pos++] = 39;
                            break;
                        }
                        case '\"': {
                            result[pos++] = 34;
                            break;
                        }
                        case 'x': {
                            code = 0;
                            if (i + 1 >= len || !TextFormat.isHex(input.charAt(i + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextFormat.digitValue(input.charAt(++i));
                            if (i + 1 < len && TextFormat.isHex(input.charAt(i + 1))) {
                                code = code * 16 + TextFormat.digitValue(input.charAt(++i));
                            }
                            result[pos++] = (byte)code;
                            break;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + c + '\'');
                        }
                    }
                    continue;
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            result[pos++] = (byte)c;
        }
        buffer.limit(pos);
        return buffer;
    }

    static String escapeText(String input) {
        return TextFormat.escapeBytes(ByteBuffer.wrap(input.getBytes(ISO_8859_1))).toString();
    }

    static String unescapeText(String input) {
        ByteBuffer buffer = TextFormat.unescapeBytes(input);
        return new String(buffer.array(), buffer.position(), buffer.limit(), ISO_8859_1);
    }

    private static boolean isOctal(char c) {
        return '0' <= c && c <= '7';
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    private static int digitValue(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'z') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    static int parseInt32(String text) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text, true, false);
    }

    static int parseUInt32(String text) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text, false, false);
    }

    static long parseInt64(String text) throws NumberFormatException {
        return TextFormat.parseInteger(text, true, true);
    }

    static long parseUInt64(String text) throws NumberFormatException {
        return TextFormat.parseInteger(text, false, true);
    }

    private static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text.startsWith("-", pos)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text);
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text.substring(pos);
        long result = 0L;
        if (numberText.length() < 16) {
            result = Long.parseLong(numberText, radix);
            if (negative) {
                result = -result;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (result >= 0x100000000L || result < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text);
            }
            result = bigValue.longValue();
        }
        return result;
    }

    static class InvalidEscapeSequenceException
    extends RuntimeException {
        private static final long serialVersionUID = -8164033650142593305L;

        InvalidEscapeSequenceException(String description) {
            super(description);
        }
    }
}

