/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DefaultProtoLoader
implements Proto.Loader {
    protected static final int ALL = 0;
    protected static final int PROTO_PATH_ONLY = 1;
    protected static final int PROTO_PATH_AND_CLASSPATH = 2;
    public static final int DEFAULT_PROTO_SEARCH_STRATEGY = Integer.getInteger("proto_search_strategy", 0);
    public static final DefaultProtoLoader DEFAULT_INSTANCE = new DefaultProtoLoader();
    private static final ArrayList<File> __protoLoadDirs = new ArrayList();
    protected final int protoSearchStrategy;

    public static DefaultProtoLoader getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public DefaultProtoLoader() {
        this(DEFAULT_PROTO_SEARCH_STRATEGY);
    }

    public DefaultProtoLoader(int protoSearchStrategy) {
        this.protoSearchStrategy = protoSearchStrategy;
    }

    @Override
    public Proto load(String path, Proto importer) throws Exception {
        switch (this.protoSearchStrategy) {
            case 0: {
                return this.searchFromAll(path, importer);
            }
            case 1: {
                return this.searchFromProtoPathOnly(path, importer);
            }
            case 2: {
                return this.searchFromProtoPathAndClasspath(path, importer);
            }
        }
        return this.searchFromAll(path, importer);
    }

    protected Proto searchFromProtoPathOnly(String path, Proto importer) throws Exception {
        for (File dir : __protoLoadDirs) {
            File protoFile = new File(dir, path);
            if (!protoFile.exists()) continue;
            return this.loadFrom(protoFile, importer);
        }
        throw new IllegalStateException("Imported proto " + path + " not found. (" + importer.getSourcePath() + ")");
    }

    protected Proto searchFromProtoPathAndClasspath(String path, Proto importer) throws Exception {
        for (File dir : __protoLoadDirs) {
            File protoFile = new File(dir, path);
            if (!protoFile.exists()) continue;
            return this.loadFrom(protoFile, importer);
        }
        Proto protoFromOtherResource = this.loadFromOtherResource(path, importer);
        if (protoFromOtherResource == null) {
            throw new IllegalStateException("Imported proto " + path + " not found. (" + importer.getSourcePath() + ")");
        }
        return protoFromOtherResource;
    }

    protected Proto searchFromAll(String path, Proto importer) throws Exception {
        File protoFile;
        if (path.startsWith("http://")) {
            URL url = new URL(path);
            return this.loadFrom(url, importer);
        }
        File importerFile = importer.getFile();
        if (importerFile == null) {
            protoFile = new File(path);
        } else {
            File baseDir;
            protoFile = new File(importerFile.getAbsoluteFile().getParentFile(), path);
            if (!protoFile.exists() && !(protoFile = new File(path)).exists() && (baseDir = DefaultProtoLoader.getBaseDirFromPackagePath(path, importer)) != null) {
                protoFile = new File(baseDir, path);
            }
            if (!protoFile.exists() && !__protoLoadDirs.isEmpty()) {
                File dir;
                Iterator<File> i$ = __protoLoadDirs.iterator();
                while (i$.hasNext() && !(protoFile = new File(dir = i$.next(), path)).exists()) {
                }
            }
        }
        if (protoFile.exists()) {
            return this.loadFrom(protoFile, importer);
        }
        Proto protoFromOtherResource = this.loadFromOtherResource(path, importer);
        if (protoFromOtherResource == null) {
            throw new IllegalStateException("Imported proto " + path + " not found. (" + importer.getSourcePath() + ")");
        }
        return protoFromOtherResource;
    }

    static File getBaseDirFromPackagePath(String path, Proto importer) {
        String importerPkg = importer.getPackageName();
        if (importerPkg == null) {
            return null;
        }
        File baseDir = importer.getFile().getAbsoluteFile().getParentFile();
        int i = 0;
        while ((i = importerPkg.indexOf(46, i)) != -1) {
            baseDir = baseDir.getParentFile();
            ++i;
        }
        return baseDir;
    }

    protected Proto loadFromOtherResource(String path, Proto importer) throws Exception {
        URL resource = DefaultProtoLoader.getResource(path, DefaultProtoLoader.class);
        return resource == null ? null : this.loadFrom(resource, importer);
    }

    protected Proto loadFrom(File file, Proto importer) throws Exception {
        Proto proto = new Proto(file, (Proto.Loader)this, importer);
        ProtoUtil.loadFrom(file, proto);
        return proto;
    }

    protected Proto loadFrom(URL resource, Proto importer) throws Exception {
        Proto proto = new Proto(resource, (Proto.Loader)this, importer);
        ProtoUtil.loadFrom(resource, proto);
        return proto;
    }

    public static Proto loadFromClasspath(String path, Proto importer) throws Exception {
        URL resource = DefaultProtoLoader.getResource(path, DefaultProtoLoader.class);
        if (resource == null) {
            return null;
        }
        Proto proto = new Proto(resource, (Proto.Loader)DEFAULT_INSTANCE, importer);
        ProtoUtil.loadFrom(resource, proto);
        return proto;
    }

    public static URL getResource(String resource, Class<?> context) {
        return DefaultProtoLoader.getResource(resource, context, false);
    }

    public static URL getResource(String resource, Class<?> context, boolean checkParent) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        if (url != null) {
            return url;
        }
        if (context != null) {
            ClassLoader loader = context.getClassLoader();
            while (loader != null) {
                url = loader.getResource(resource);
                if (url != null) {
                    return url;
                }
                loader = checkParent ? loader.getParent() : null;
            }
        }
        return ClassLoader.getSystemResource(resource);
    }

    static {
        String protoPath = System.getProperty("proto_path");
        if (protoPath != null) {
            StringTokenizer tokenizer = new StringTokenizer(protoPath, ",:;");
            while (tokenizer.hasMoreTokens()) {
                String path = tokenizer.nextToken().trim();
                File dir = new File(path);
                if (dir.exists() && dir.isDirectory()) {
                    __protoLoadDirs.add(dir);
                    continue;
                }
                System.err.println("warn: " + path + " not found.");
            }
        }
    }
}

