/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor;
import java.util.Objects;
import java.util.function.Supplier;

public final class SimpleLogRecordProcessorBuilder {
    private final LogRecordExporter exporter;
    private Supplier<MeterProvider> meterProvider = MeterProvider::noop;

    SimpleLogRecordProcessorBuilder(LogRecordExporter exporter) {
        this.exporter = Objects.requireNonNull(exporter, "exporter");
    }

    public SimpleLogRecordProcessorBuilder setMeterProvider(Supplier<MeterProvider> meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    public SimpleLogRecordProcessor build() {
        return new SimpleLogRecordProcessor(this.exporter, this.meterProvider);
    }
}

