/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure;

import io.micrometer.spring.autoconfigure.ServiceLevelAgreementBoundary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="management.metrics")
public class MetricsProperties {
    private Web web = new Web();
    private Distribution distribution = new Distribution();
    private Map<String, Boolean> enable = new HashMap<String, Boolean>();
    private boolean useGlobalRegistry = true;

    public boolean isUseGlobalRegistry() {
        return this.useGlobalRegistry;
    }

    public void setUseGlobalRegistry(boolean useGlobalRegistry) {
        this.useGlobalRegistry = useGlobalRegistry;
    }

    public Web getWeb() {
        return this.web;
    }

    public Map<String, Boolean> getEnable() {
        return this.enable;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public static class Distribution {
        private Map<String, Boolean> percentilesHistogram = new LinkedHashMap<String, Boolean>();
        private Map<String, double[]> percentiles = new LinkedHashMap<String, double[]>();
        private Map<String, ServiceLevelAgreementBoundary[]> sla = new LinkedHashMap<String, ServiceLevelAgreementBoundary[]>();

        public Map<String, Boolean> getPercentilesHistogram() {
            return this.percentilesHistogram;
        }

        public void setPercentilesHistogram(Map<String, Boolean> percentilesHistogram) {
            Assert.notNull(percentilesHistogram, (String)"PercentilesHistogram must not be null");
            this.percentilesHistogram = percentilesHistogram;
        }

        public Map<String, double[]> getPercentiles() {
            return this.percentiles;
        }

        public void setPercentiles(Map<String, double[]> percentiles) {
            Assert.notNull(percentiles, (String)"Percentiles must not be null");
            this.percentiles = percentiles;
        }

        public Map<String, ServiceLevelAgreementBoundary[]> getSla() {
            return this.sla;
        }

        public void setSla(Map<String, ServiceLevelAgreementBoundary[]> sla) {
            Assert.notNull(sla, (String)"SLA must not be null");
            this.sla = sla;
        }
    }

    public static class Web {
        private Client client = new Client();
        private Server server = new Server();

        public Client getClient() {
            return this.client;
        }

        public Server getServer() {
            return this.server;
        }

        public static class Server {
            private boolean autoTimeRequests = true;
            private String requestsMetricName = "http.server.requests";

            public boolean isAutoTimeRequests() {
                return this.autoTimeRequests;
            }

            public void setAutoTimeRequests(boolean autoTimeRequests) {
                this.autoTimeRequests = autoTimeRequests;
            }

            public String getRequestsMetricName() {
                return this.requestsMetricName;
            }

            public void setRequestsMetricName(String requestsMetricName) {
                this.requestsMetricName = requestsMetricName;
            }
        }

        public static class Client {
            private String requestsMetricName = "http.client.requests";
            private int maxUriTags = 100;

            public String getRequestsMetricName() {
                return this.requestsMetricName;
            }

            public void setRequestsMetricName(String requestsMetricName) {
                this.requestsMetricName = requestsMetricName;
            }

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }
        }
    }
}

