/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.Range;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.models.stream.PendingMessages;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public class PendingMessagesOutput<K, V>
extends CommandOutput<K, V, PendingMessages> {
    private Long count;
    private String messageIdsFrom;
    private String messageIdsTo;
    private String consumer;
    private final Map<String, Long> consumerMessageCount = new LinkedHashMap<String, Long>();

    public PendingMessagesOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.messageIdsFrom == null) {
            this.messageIdsFrom = this.decodeAscii(bytes);
            return;
        }
        if (this.messageIdsTo == null) {
            this.messageIdsTo = this.decodeAscii(bytes);
            return;
        }
        if (this.consumer == null) {
            this.consumer = StringCodec.UTF8.decodeKey(bytes);
            return;
        }
        this.set(Long.parseLong(this.decodeAscii(bytes)));
    }

    @Override
    public void set(long integer) {
        if (this.count == null) {
            this.count = integer;
            return;
        }
        if (this.consumer != null) {
            this.consumerMessageCount.put(this.consumer, integer);
            this.consumer = null;
        }
    }

    @Override
    public void complete(int depth) {
        if (depth == 0) {
            Range<String> range = this.messageIdsFrom != null && this.messageIdsTo != null ? Range.create(this.messageIdsFrom, this.messageIdsTo) : Range.unbounded();
            this.output = new PendingMessages(this.count == null ? 0L : this.count, range, this.consumerMessageCount);
        }
    }
}

