/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.topology;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.models.partitions.ClusterPartitionParser;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.cluster.topology.Requests;
import io.lettuce.core.cluster.topology.TimedAsyncCommand;
import io.lettuce.core.cluster.topology.TopologyComparators;
import io.lettuce.core.internal.LettuceStrings;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NodeTopologyView {
    private final boolean available;
    private final RedisURI redisURI;
    private Partitions partitions;
    private final int connectedClients;
    private final long replicationOffset;
    private final long latency;
    private final String clusterNodes;
    private final String info;
    private static final Pattern CONNECTED_CLIENTS_PATTERN = NodeTopologyView.patternFor("connected_clients");
    private static final Pattern MASTER_REPL_OFFSET_PATTERN = NodeTopologyView.patternFor("master_repl_offset");

    private NodeTopologyView(RedisURI redisURI) {
        this.available = false;
        this.redisURI = redisURI;
        this.partitions = new Partitions();
        this.connectedClients = 0;
        this.replicationOffset = -1L;
        this.clusterNodes = null;
        this.info = null;
        this.latency = 0L;
    }

    NodeTopologyView(RedisURI redisURI, String clusterNodes, String info2, long latency) {
        this.available = true;
        this.redisURI = redisURI;
        this.partitions = ClusterPartitionParser.parse(clusterNodes);
        this.connectedClients = this.getClientCount(info2);
        this.replicationOffset = this.getReplicationOffset(info2);
        this.clusterNodes = clusterNodes;
        this.info = info2;
        this.latency = latency;
    }

    private static Pattern patternFor(String propertyName) {
        return Pattern.compile(String.format("^%s:(.*)$", Pattern.quote(propertyName)), 8);
    }

    private int getClientCount(String info2) {
        return NodeTopologyView.getMatchOrDefault(info2, CONNECTED_CLIENTS_PATTERN, Integer::parseInt, 0);
    }

    private long getReplicationOffset(String info2) {
        return NodeTopologyView.getMatchOrDefault(info2, MASTER_REPL_OFFSET_PATTERN, Long::parseLong, -1L);
    }

    private static <T> T getMatchOrDefault(String haystack, Pattern pattern, Function<String, T> converter, T defaultValue) {
        Matcher matcher = pattern.matcher(haystack);
        if (matcher.find() && LettuceStrings.isNotEmpty(matcher.group(1))) {
            return converter.apply(matcher.group(1));
        }
        return defaultValue;
    }

    static NodeTopologyView from(RedisURI redisURI, Requests clusterNodesRequests, Requests infoRequests) {
        TimedAsyncCommand<String, String, String> nodes = clusterNodesRequests.getRequest(redisURI);
        TimedAsyncCommand<String, String, String> info2 = infoRequests.getRequest(redisURI);
        if (NodeTopologyView.resultAvailable(nodes) && !nodes.isCompletedExceptionally() && NodeTopologyView.resultAvailable(info2)) {
            return new NodeTopologyView(redisURI, (String)nodes.join(), NodeTopologyView.optionallyGet(info2), nodes.duration());
        }
        return new NodeTopologyView(redisURI);
    }

    private static <T> T optionallyGet(TimedAsyncCommand<?, ?, T> command) {
        if (command.isCompletedExceptionally()) {
            return null;
        }
        return command.join();
    }

    private static boolean resultAvailable(RedisFuture<?> redisFuture) {
        return redisFuture != null && redisFuture.isDone() && !redisFuture.isCancelled();
    }

    String getNodeId() {
        return this.getOwnPartition().getNodeId();
    }

    RedisURI getRedisURI() {
        if (this.partitions.isEmpty()) {
            return this.redisURI;
        }
        return this.getOwnPartition().getUri();
    }

    RedisClusterNode getOwnPartition() {
        RedisClusterNode own = this.findOwnPartition();
        if (own != null) {
            return own;
        }
        throw new IllegalStateException("Cannot determine own partition");
    }

    private RedisClusterNode findOwnPartition() {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.is(RedisClusterNode.NodeFlag.MYSELF)) continue;
            return partition;
        }
        return null;
    }

    void postProcessPartitions() {
        TopologyComparators.SortAction sortAction = TopologyComparators.SortAction.getSortAction();
        sortAction.sort(this.getPartitions());
        this.getPartitions().updateCache();
    }

    public boolean canContribute() {
        RedisClusterNode ownPartition = this.findOwnPartition();
        return ownPartition != null;
    }

    long getLatency() {
        return this.latency;
    }

    boolean isAvailable() {
        return this.available;
    }

    Partitions getPartitions() {
        return this.partitions;
    }

    int getConnectedClients() {
        return this.connectedClients;
    }

    long getReplicationOffset() {
        return this.replicationOffset;
    }

    String getInfo() {
        return this.info;
    }

    String getClusterNodes() {
        return this.clusterNodes;
    }

    void setPartitions(Partitions partitions) {
        this.partitions = partitions;
    }
}

