/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.featuredetection.adap3d.algorithms.ADAP3DPeakDetectionAlgorithm;
import io.github.msdk.featuredetection.adap3d.algorithms.ContinuousWaveletTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SliceSparseMatrix {
    private final HashMap<Integer, Float> rtMap;
    private final List<Triplet> sortListAccordingToMzScan;
    private final List<Triplet> sortListAccordingToIntensity;
    private final List<Triplet> sortListAccordingToScan;
    Comparator<Triplet> compareMzScan;
    Comparator<Triplet> compareIntensity;
    Comparator<Triplet> compareScanMz;
    Comparator<Triplet> compareScan;
    private final List<Triplet> filterListOfTriplet;
    private int maxIntensityIndex = 0;
    private final int roundMzFactor = 10000;
    private final List<MsScan> listOfScans;
    public final List<Integer> mzValues;

    public SliceSparseMatrix(RawDataFile rawFile) {
        this(rawFile, s -> true);
    }

    public SliceSparseMatrix(RawDataFile rawFile, Predicate<MsScan> msScanPredicate) {
        this.listOfScans = rawFile.getScans().stream().filter(msScanPredicate).collect(Collectors.toList());
        ArrayList<Triplet> listOfTriplet = new ArrayList<Triplet>();
        this.rtMap = new HashMap();
        for (int i = 0; i < this.listOfScans.size(); ++i) {
            MsScan scan = this.listOfScans.get(i);
            if (scan == null) continue;
            double[] mzBuffer = scan.getMzValues();
            float[] intensityBuffer = scan.getIntensityValues();
            Float rt = scan.getRetentionTime();
            if (rt == null) continue;
            this.rtMap.put(i, rt);
            for (int j = 0; j < mzBuffer.length; ++j) {
                Triplet triplet = new Triplet();
                triplet.intensity = intensityBuffer[j];
                triplet.mz = this.roundMZ(mzBuffer[j]);
                triplet.scanListIndex = i;
                triplet.removed = 0;
                listOfTriplet.add(triplet);
            }
        }
        this.compareScanMz = new Comparator<Triplet>(){

            @Override
            public int compare(Triplet o1, Triplet o2) {
                int scan1 = o1.scanListIndex;
                int scan2 = o2.scanListIndex;
                int scanCompare = Integer.compare(scan1, scan2);
                if (scanCompare != 0) {
                    return scanCompare;
                }
                int mz1 = o1.mz;
                int mz2 = o2.mz;
                return Integer.compare(mz1, mz2);
            }
        };
        Collections.sort(listOfTriplet, this.compareScanMz);
        this.filterListOfTriplet = new ArrayList<Triplet>();
        Triplet currTriplet = new Triplet();
        Triplet lastFilterTriplet = new Triplet();
        int index = 0;
        HashSet<Integer> mzSet = new HashSet<Integer>();
        this.filterListOfTriplet.add((Triplet)listOfTriplet.get(0));
        for (int i = 1; i < listOfTriplet.size(); ++i) {
            currTriplet = (Triplet)listOfTriplet.get(i);
            mzSet.add(((Triplet)listOfTriplet.get((int)i)).mz);
            lastFilterTriplet = this.filterListOfTriplet.get(index);
            if (!(currTriplet.intensity > 1000.0f)) continue;
            if (currTriplet.mz == lastFilterTriplet.mz && currTriplet.scanListIndex == lastFilterTriplet.scanListIndex) {
                lastFilterTriplet.intensity += currTriplet.intensity;
                continue;
            }
            this.filterListOfTriplet.add(currTriplet);
            ++index;
        }
        this.mzValues = new ArrayList<Integer>(mzSet);
        Collections.sort(this.mzValues);
        this.sortListAccordingToScan = new ArrayList<Triplet>(this.filterListOfTriplet);
        this.compareScan = new Comparator<Triplet>(){

            @Override
            public int compare(Triplet o1, Triplet o2) {
                int scan1 = o1.scanListIndex;
                int scan2 = o2.scanListIndex;
                int scanCompare = Integer.compare(scan1, scan2);
                return scanCompare;
            }
        };
        Collections.sort(this.sortListAccordingToScan, this.compareScan);
        this.sortListAccordingToIntensity = new ArrayList<Triplet>(this.filterListOfTriplet);
        this.compareIntensity = new Comparator<Triplet>(){

            @Override
            public int compare(Triplet o1, Triplet o2) {
                Float intensity1 = Float.valueOf(o1.intensity);
                Float intensity2 = Float.valueOf(o2.intensity);
                int intensityCompare = intensity2.compareTo(intensity1);
                return intensityCompare;
            }
        };
        Collections.sort(this.sortListAccordingToIntensity, this.compareIntensity);
        this.sortListAccordingToMzScan = new ArrayList<Triplet>(this.filterListOfTriplet);
        this.compareMzScan = new Comparator<Triplet>(){

            @Override
            public int compare(Triplet o1, Triplet o2) {
                int mz1 = o1.mz;
                int mz2 = o2.mz;
                int scanCompare = Integer.compare(mz1, mz2);
                if (scanCompare != 0) {
                    return scanCompare;
                }
                int scan1 = o1.scanListIndex;
                int scan2 = o2.scanListIndex;
                return Integer.compare(scan1, scan2);
            }
        };
        Collections.sort(this.sortListAccordingToMzScan, this.compareMzScan);
    }

    public List<Triplet> getHorizontalSlice(double mz, int lowerScanBound, int upperScanBound) {
        int roundedmz = this.roundMZ(mz);
        ArrayList<Triplet> sliceList = new ArrayList<Triplet>();
        for (int i = lowerScanBound; i <= upperScanBound; ++i) {
            Triplet searchTriplet = new Triplet();
            searchTriplet.mz = roundedmz;
            searchTriplet.scanListIndex = i;
            int index = Collections.binarySearch(this.sortListAccordingToMzScan, searchTriplet, this.compareMzScan);
            if (index >= 0) {
                Triplet triplet = this.sortListAccordingToMzScan.get(index);
                sliceList.add(triplet);
                continue;
            }
            searchTriplet.intensity = 0.0f;
            searchTriplet.removed = 0;
            sliceList.add(searchTriplet);
        }
        return sliceList;
    }

    public List<Triplet> getHorizontalSlice(int roundedMZ, int lowerScanBound, int upperScanBound) {
        return this.getHorizontalSlice((double)roundedMZ / 10000.0, lowerScanBound, upperScanBound);
    }

    public List<VerticalSliceDataPoint> getVerticalSlice(int scanNumber) {
        int index1;
        ArrayList<Triplet> oneScanTriplet = new ArrayList<Triplet>();
        ArrayList<VerticalSliceDataPoint> datapointList = new ArrayList<VerticalSliceDataPoint>();
        Triplet searchTriplet = new Triplet();
        searchTriplet.scanListIndex = scanNumber;
        int index2 = index1 = Collections.binarySearch(this.sortListAccordingToScan, searchTriplet, this.compareScan);
        oneScanTriplet.add(this.sortListAccordingToScan.get(index1));
        while (index1 >= 0 && --index1 >= 0 && this.sortListAccordingToScan.get((int)index1).scanListIndex == scanNumber) {
            oneScanTriplet.add(this.sortListAccordingToScan.get(index1));
        }
        while (index2 >= 0 && ++index2 <= this.filterListOfTriplet.size() - 1 && this.filterListOfTriplet.get((int)index2).scanListIndex == scanNumber) {
            oneScanTriplet.add(this.filterListOfTriplet.get(index2));
        }
        Collections.sort(oneScanTriplet, this.compareIntensity);
        int maxIntensityMZ = ((Triplet)oneScanTriplet.get((int)0)).mz;
        Collections.sort(oneScanTriplet, this.compareScanMz);
        Triplet searchMz = new Triplet();
        for (int roundedMZ : this.mzValues) {
            VerticalSliceDataPoint datapoint = new VerticalSliceDataPoint();
            searchMz.mz = roundedMZ;
            searchMz.scanListIndex = scanNumber;
            if (roundedMZ < maxIntensityMZ - 10000 || roundedMZ > maxIntensityMZ + 10000) continue;
            int mzInex = Collections.binarySearch(oneScanTriplet, searchMz, this.compareScanMz);
            if (mzInex >= 0) {
                datapoint.intensity = ((Triplet)oneScanTriplet.get((int)mzInex)).intensity;
                datapoint.mz = (float)roundedMZ / 10000.0f;
                datapointList.add(datapoint);
                continue;
            }
            datapoint.intensity = 0.0f;
            datapoint.mz = (float)roundedMZ / 10000.0f;
            datapointList.add(datapoint);
        }
        return datapointList;
    }

    public Triplet findNextMaxIntensity() {
        Triplet tripletObject = null;
        for (int i = this.maxIntensityIndex; i < this.sortListAccordingToIntensity.size(); ++i) {
            if (this.sortListAccordingToIntensity.get((int)i).removed != 0) continue;
            tripletObject = this.sortListAccordingToIntensity.get(i);
            this.maxIntensityIndex = i + 1;
            break;
        }
        return tripletObject;
    }

    public List<ContinuousWaveletTransform.DataPoint> getCWTDataPoint(List<Triplet> slice) {
        Iterator<Triplet> iterator = slice.iterator();
        ArrayList<ContinuousWaveletTransform.DataPoint> listOfDataPoint = new ArrayList<ContinuousWaveletTransform.DataPoint>();
        while (iterator.hasNext()) {
            ContinuousWaveletTransform.DataPoint dataPoint = new ContinuousWaveletTransform.DataPoint();
            Triplet triplet = iterator.next();
            if (triplet.intensity != 0.0f && triplet.removed == 0) {
                dataPoint.rt = this.rtMap.get(triplet.scanListIndex).floatValue() / 60.0f;
                dataPoint.intensity = triplet.intensity;
                listOfDataPoint.add(dataPoint);
                continue;
            }
            dataPoint.rt = this.rtMap.get(triplet.scanListIndex).floatValue() / 60.0f;
            dataPoint.intensity = 0.0;
            listOfDataPoint.add(dataPoint);
        }
        Comparator<ContinuousWaveletTransform.DataPoint> compare = new Comparator<ContinuousWaveletTransform.DataPoint>(){

            @Override
            public int compare(ContinuousWaveletTransform.DataPoint o1, ContinuousWaveletTransform.DataPoint o2) {
                Double rt1 = o1.rt;
                Double rt2 = o2.rt;
                return rt1.compareTo(rt2);
            }
        };
        Collections.sort(listOfDataPoint, compare);
        return listOfDataPoint;
    }

    public List<Triplet> removeDataPoints(int roundedmz, int lowerScanBound, int upperScanBound) {
        Triplet searchTriplet = new Triplet();
        for (int i = lowerScanBound; i <= upperScanBound; ++i) {
            searchTriplet.mz = roundedmz;
            searchTriplet.scanListIndex = i;
            int index = Collections.binarySearch(this.filterListOfTriplet, searchTriplet, this.compareScanMz);
            if (index < 0) continue;
            Triplet triplet = this.filterListOfTriplet.get(index);
            triplet.removed = 1;
        }
        return this.filterListOfTriplet;
    }

    public List<Triplet> restoreDataPoints(int roundedmz, int lowerScanBound, int upperScanBound) {
        Triplet searchTriplet = new Triplet();
        for (int i = lowerScanBound; i <= upperScanBound; ++i) {
            searchTriplet.mz = roundedmz;
            searchTriplet.scanListIndex = i;
            int index = Collections.binarySearch(this.filterListOfTriplet, searchTriplet, this.compareScanMz);
            if (index < 0) continue;
            Triplet triplet = this.filterListOfTriplet.get(index);
            triplet.removed = 0;
        }
        return this.filterListOfTriplet;
    }

    public int roundMZ(double mz) {
        int roundedmz = (int)Math.round(mz * 10000.0);
        return roundedmz;
    }

    public void setMaxIntensityIndexZero() {
        this.maxIntensityIndex = 0;
    }

    public int getSizeOfRawDataFile() {
        int size = this.listOfScans.size();
        return size;
    }

    public float[] getRetentionTimeArray(int lowerScanBound, int upperScanbound) {
        float[] retentionTime = new float[upperScanbound - lowerScanBound + 1];
        for (int i = 0; i < upperScanbound - lowerScanBound + 1; ++i) {
            retentionTime[i] = (float)this.getRetentionTime(i + lowerScanBound);
        }
        return retentionTime;
    }

    public float[] getIntensities(ADAP3DPeakDetectionAlgorithm.GoodPeakInfo peak) {
        float[] intensities = new float[peak.upperScanBound - peak.lowerScanBound + 1];
        for (int i = 0; i < peak.upperScanBound - peak.lowerScanBound + 1; ++i) {
            Triplet searchTriplet = new Triplet();
            searchTriplet.scanListIndex = i + peak.lowerScanBound;
            searchTriplet.mz = this.roundMZ(peak.mz);
            int index = Collections.binarySearch(this.filterListOfTriplet, searchTriplet, this.compareScanMz);
            intensities[i] = index >= 0 ? this.filterListOfTriplet.get((int)index).intensity : 0.0f;
        }
        return intensities;
    }

    public double getRetentionTime(int scanNumber) {
        return this.rtMap.get(scanNumber).floatValue();
    }

    public float getFinishedPercent(Triplet maxIntensityTriplet) {
        int index = Collections.binarySearch(this.sortListAccordingToIntensity, maxIntensityTriplet, this.compareIntensity);
        float progress = index / this.sortListAccordingToIntensity.size();
        return progress;
    }

    public double numOfScans() {
        return this.listOfScans.size();
    }

    public static class VerticalSliceDataPoint {
        float mz;
        float intensity;
    }

    public static class Triplet {
        public int mz;
        public int scanListIndex;
        public float intensity;
        public byte removed;
    }
}

