/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import io.github.msdk.featuredetection.adap3d.algorithms.BiGaussian;
import io.github.msdk.featuredetection.adap3d.algorithms.CurveTool;
import io.github.msdk.featuredetection.adap3d.algorithms.SliceSparseMatrix;
import java.util.List;
import java.util.stream.IntStream;

public class BiGaussianSimilarityTest {
    public boolean execute(List<SliceSparseMatrix.Triplet> slice, int leftBound, int rightBound, int roundedMZ, double biGaussianSimilarityThreshold) {
        double[] referenceEIC = new double[rightBound - leftBound + 1];
        CurveTool.normalize(slice, leftBound, rightBound, roundedMZ, referenceEIC);
        try {
            BiGaussian objBiGaussian = new BiGaussian(slice, roundedMZ, leftBound, rightBound);
            double[] bigaussianValues = IntStream.range(0, referenceEIC.length).mapToDouble(i -> objBiGaussian.getValue(leftBound + i)).toArray();
            double[] normBigaussianValues = new double[rightBound - leftBound + 1];
            CurveTool.normalize(bigaussianValues, normBigaussianValues);
            double similarityValue = CurveTool.similarityValue(referenceEIC, normBigaussianValues, leftBound, rightBound);
            return similarityValue > biGaussianSimilarityThreshold;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

