/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import io.github.msdk.featuredetection.adap3d.ADAP3DFeatureDetectionParameters;
import io.github.msdk.featuredetection.adap3d.algorithms.BiGaussianSimilarityTest;
import io.github.msdk.featuredetection.adap3d.algorithms.ContinuousWaveletTransform;
import io.github.msdk.featuredetection.adap3d.algorithms.Peak3DTest;
import io.github.msdk.featuredetection.adap3d.algorithms.SliceSparseMatrix;
import io.github.msdk.featuredetection.adap3d.datamodel.Result;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADAP3DPeakDetectionAlgorithm {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SliceSparseMatrix objSliceSparseMatrix;
    private boolean canceled = false;
    private float progressPercent;

    public ADAP3DPeakDetectionAlgorithm(SliceSparseMatrix objSliceSparseMatrix) {
        this.objSliceSparseMatrix = objSliceSparseMatrix;
    }

    public List<GoodPeakInfo> execute(int numOfPeaks, ADAP3DFeatureDetectionParameters objParameters, int roundedFWHM) {
        this.logger.debug("Starting ADAP3D algorithm for " + numOfPeaks + " peaks");
        int maxCount = 0;
        SliceSparseMatrix.Triplet maxIntensityTriplet = this.objSliceSparseMatrix.findNextMaxIntensity();
        ArrayList<GoodPeakInfo> peakList = new ArrayList<GoodPeakInfo>();
        while (maxCount < numOfPeaks && maxCount != 20) {
            GoodPeakInfo goodPeak = this.iteration(maxIntensityTriplet, roundedFWHM, objParameters);
            if (goodPeak != null) {
                ++maxCount;
                peakList.add(goodPeak);
            }
            if (this.canceled) {
                return peakList;
            }
            this.progressPercent = this.objSliceSparseMatrix.getFinishedPercent(maxIntensityTriplet);
            maxIntensityTriplet = this.objSliceSparseMatrix.findNextMaxIntensity();
        }
        this.logger.debug("Finished ADAP3D algorithm for " + numOfPeaks + " peaks");
        return peakList;
    }

    public List<GoodPeakInfo> execute(ADAP3DFeatureDetectionParameters objParameters, int roundedFWHM) {
        this.logger.debug("Starting ADAP3D algorithm for all good peaks");
        SliceSparseMatrix.Triplet maxIntensityTriplet = this.objSliceSparseMatrix.findNextMaxIntensity();
        ArrayList<GoodPeakInfo> peakList = new ArrayList<GoodPeakInfo>();
        while (maxIntensityTriplet != null) {
            if (this.canceled) {
                return null;
            }
            GoodPeakInfo goodPeak = this.iteration(maxIntensityTriplet, roundedFWHM, objParameters);
            if (goodPeak != null) {
                peakList.add(goodPeak);
            }
            maxIntensityTriplet = this.objSliceSparseMatrix.findNextMaxIntensity();
        }
        this.logger.debug("Finished ADAP3D algorithm for all good peaks");
        return peakList;
    }

    private GoodPeakInfo iteration(SliceSparseMatrix.Triplet triplet, int fwhm, ADAP3DFeatureDetectionParameters objParameters) {
        GoodPeakInfo objPeakInfo = null;
        int lowerScanBound = triplet.scanListIndex - objParameters.getDelta() < 0 ? 0 : triplet.scanListIndex - objParameters.getDelta();
        int upperScanBound = triplet.scanListIndex + objParameters.getDelta() >= this.objSliceSparseMatrix.getSizeOfRawDataFile() ? this.objSliceSparseMatrix.getSizeOfRawDataFile() - 1 : triplet.scanListIndex + objParameters.getDelta();
        List<SliceSparseMatrix.Triplet> slice = this.objSliceSparseMatrix.getHorizontalSlice(triplet.mz, lowerScanBound, upperScanBound);
        ContinuousWaveletTransform continuousWavelet = new ContinuousWaveletTransform(1.0, objParameters.getLargeScaleIn(), 1.0);
        ArrayList<ContinuousWaveletTransform.DataPoint> listOfDataPoint = new ArrayList();
        listOfDataPoint = this.objSliceSparseMatrix.getCWTDataPoint(slice);
        continuousWavelet.setX(listOfDataPoint);
        continuousWavelet.setSignal(listOfDataPoint);
        continuousWavelet.setPeakWidth(objParameters.getMinPeakWidth(), objParameters.getMaxPeakWidth());
        continuousWavelet.setcoefAreaRatioTolerance(objParameters.getCoefAreaRatioTolerance());
        List<Result> peakList = continuousWavelet.findPeaks();
        if (peakList.isEmpty()) {
            this.removeDataPoints(triplet.mz - fwhm, triplet.mz + fwhm, lowerScanBound, upperScanBound);
        } else {
            Peak3DTest objPeak3DTest = new Peak3DTest(this.objSliceSparseMatrix, fwhm);
            BiGaussianSimilarityTest objBiGaussianTest = new BiGaussianSimilarityTest();
            boolean remove = true;
            for (int i = 0; i < peakList.size(); ++i) {
                List<SliceSparseMatrix.Triplet> curSlice = this.objSliceSparseMatrix.getHorizontalSlice(triplet.mz, peakList.get((int)i).curLeftBound + lowerScanBound, peakList.get((int)i).curRightBound + lowerScanBound);
                double sliceMaxIntensity = curSlice.stream().map(x -> x != null ? (double)x.intensity : 0.0).max(Double::compareTo).orElse(0.0);
                int scanNumber = curSlice.stream().map(x -> x != null && (double)x.intensity == sliceMaxIntensity ? x.scanListIndex : 0).max(Integer::compareTo).orElse(0);
                if (scanNumber != triplet.scanListIndex) {
                    if (remove) {
                        this.removeDataPoints(triplet.mz - fwhm, triplet.mz + fwhm, lowerScanBound, upperScanBound);
                        remove = false;
                    }
                    this.restoreDataPoints(triplet.mz - fwhm, triplet.mz + fwhm, peakList.get((int)i).curLeftBound + lowerScanBound, peakList.get((int)i).curRightBound + lowerScanBound);
                    continue;
                }
                Peak3DTest.Result peak = objPeak3DTest.execute(triplet.mz, peakList.get((int)i).curLeftBound + lowerScanBound, peakList.get((int)i).curRightBound + lowerScanBound, objParameters.getPeakSimilarityThreshold());
                boolean goodPeak = objBiGaussianTest.execute(curSlice, peakList.get((int)i).curLeftBound + lowerScanBound, peakList.get((int)i).curRightBound + lowerScanBound, triplet.mz, objParameters.getBiGaussianSimilarityThreshold());
                if (peak.goodPeak && goodPeak) {
                    this.removeDataPoints(peak.lowerMzBound, peak.upperMzBound, peakList.get((int)i).curLeftBound + lowerScanBound, peakList.get((int)i).curRightBound + lowerScanBound);
                    objPeakInfo = new GoodPeakInfo();
                    objPeakInfo.mz = (double)triplet.mz / 10000.0;
                    objPeakInfo.lowerScanBound = peakList.get((int)i).curLeftBound + lowerScanBound;
                    objPeakInfo.upperScanBound = peakList.get((int)i).curRightBound + lowerScanBound;
                    objPeakInfo.maxHeight = triplet.intensity;
                    objPeakInfo.maxHeightScanNumber = triplet.scanListIndex;
                    objPeakInfo.objResult = peakList.get(i);
                    continue;
                }
                this.removeDataPoints(peak.lowerMzBound, peak.upperMzBound, peakList.get((int)i).curLeftBound + lowerScanBound, peakList.get((int)i).curRightBound + lowerScanBound);
            }
        }
        return objPeakInfo;
    }

    private void removeDataPoints(int lowerMZ, int upperMZ, int lowerScanBound, int upperScanBound) {
        for (int i = lowerMZ; i <= upperMZ; ++i) {
            this.objSliceSparseMatrix.removeDataPoints(i, lowerScanBound, upperScanBound);
        }
    }

    private void restoreDataPoints(int lowerMZ, int upperMZ, int lowerScanBound, int upperScanBound) {
        for (int i = lowerMZ; i <= upperMZ; ++i) {
            this.objSliceSparseMatrix.restoreDataPoints(i, lowerScanBound, upperScanBound);
        }
    }

    public void cancel() {
        this.canceled = true;
    }

    public float getFinishedPercent() {
        return this.progressPercent;
    }

    public static class GoodPeakInfo {
        public double mz;
        public int upperScanBound;
        public int lowerScanBound;
        public float maxHeight;
        public int maxHeightScanNumber;
        public Result objResult;
    }
}

