/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classgraph.AnnotationDAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classgraph.DAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.InterfaceDAGNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

class StandardClassDAGNode
extends DAGNode {
    ArrayList<InterfaceDAGNode> implementedInterfaceClassNodes = new ArrayList(2);
    HashSet<DAGNode> fieldTypeNodes = new HashSet(2);

    public StandardClassDAGNode(ClassInfo classInfo) {
        super(classInfo);
    }

    public StandardClassDAGNode(String name) {
        super(name);
    }

    public void addImplementedInterface(InterfaceDAGNode implementedInterfaceNode) {
        this.implementedInterfaceClassNodes.add(implementedInterfaceNode);
    }

    public void addWhitelistedFieldType(DAGNode fieldTypeNode) {
        this.fieldTypeNodes.add(fieldTypeNode);
    }

    @Override
    public void connect(HashMap<String, DAGNode> classNameToDAGNode) {
        super.connect(classNameToDAGNode);
        if (this.classInfo != null) {
            if (this.classInfo.interfaceNames != null) {
                for (String interfaceName : this.classInfo.interfaceNames) {
                    InterfaceDAGNode interfaceNode = (InterfaceDAGNode)classNameToDAGNode.get(interfaceName);
                    if (interfaceNode == null) continue;
                    this.addImplementedInterface(interfaceNode);
                }
            }
            if (this.classInfo.annotationNames != null) {
                for (String annotationName : this.classInfo.annotationNames) {
                    AnnotationDAGNode annotationNode = (AnnotationDAGNode)classNameToDAGNode.get(annotationName);
                    if (annotationNode == null) continue;
                    annotationNode.addAnnotatedClass(this);
                }
            }
            if (this.classInfo.fieldTypes != null) {
                for (String fieldTypeName : this.classInfo.fieldTypes) {
                    DAGNode typeNode = classNameToDAGNode.get(fieldTypeName);
                    if (typeNode == null) continue;
                    this.addWhitelistedFieldType(typeNode);
                }
            }
        }
    }
}

