/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.tsp.ers;

import io.gatling.recorder.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.gatling.recorder.internal.bouncycastle.operator.DigestCalculator;
import io.gatling.recorder.internal.bouncycastle.tsp.ers.ERSData;
import java.util.HashMap;
import java.util.Map;

public abstract class ERSCachingData
implements ERSData {
    private Map<AlgorithmIdentifier, byte[]> preCalcs = new HashMap<AlgorithmIdentifier, byte[]>();

    @Override
    public byte[] getHash(DigestCalculator digestCalculator) {
        AlgorithmIdentifier algorithmIdentifier = digestCalculator.getAlgorithmIdentifier();
        if (this.preCalcs.containsKey(algorithmIdentifier)) {
            return this.preCalcs.get(algorithmIdentifier);
        }
        byte[] byArray = this.calculateHash(digestCalculator);
        this.preCalcs.put(algorithmIdentifier, byArray);
        return byArray;
    }

    protected abstract byte[] calculateHash(DigestCalculator var1);
}

