/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pkcs.bc;

import io.gatling.recorder.internal.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.gatling.recorder.internal.bouncycastle.crypto.CipherParameters;
import io.gatling.recorder.internal.bouncycastle.crypto.ExtendedDigest;
import io.gatling.recorder.internal.bouncycastle.crypto.digests.SHA1Digest;
import io.gatling.recorder.internal.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import io.gatling.recorder.internal.bouncycastle.crypto.io.CipherInputStream;
import io.gatling.recorder.internal.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import io.gatling.recorder.internal.bouncycastle.operator.GenericKey;
import io.gatling.recorder.internal.bouncycastle.operator.InputDecryptor;
import io.gatling.recorder.internal.bouncycastle.operator.InputDecryptorProvider;
import io.gatling.recorder.internal.bouncycastle.pkcs.bc.PKCS12PBEUtils;
import java.io.InputStream;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest extendedDigest) {
        this.digest = extendedDigest;
    }

    public InputDecryptorProvider build(final char[] cArray) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher paddedBufferedBlockCipher = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters cipherParameters = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, paddedBufferedBlockCipher.getBlockSize(), pKCS12PBEParams, cArray);
                paddedBufferedBlockCipher.init(false, cipherParameters);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream inputStream) {
                        return new CipherInputStream(inputStream, paddedBufferedBlockCipher);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
                    }
                };
            }
        };
    }
}

