package io.gatling.recorder.internal.bouncycastle.pqc.crypto.saber;

import io.gatling.recorder.internal.bouncycastle.util.Arrays;

public class SABERPrivateKeyParameters
    extends SABERKeyParameters
{
    private byte[] privateKey;

    public byte[] getPrivateKey()
    {
        return Arrays.clone(privateKey);
    }

    public SABERPrivateKeyParameters(SABERParameters params, byte[] privateKey)
    {
        super(true, params);
        this.privateKey = Arrays.clone(privateKey);
    }

    public byte[] getEncoded()
    {
        return Arrays.clone(privateKey);
    }
}
