package io.gatling.recorder.internal.bouncycastle.mime.smime;

import java.io.IOException;
import java.io.InputStream;

import io.gatling.recorder.internal.bouncycastle.mime.BasicMimeParser;
import io.gatling.recorder.internal.bouncycastle.mime.Headers;
import io.gatling.recorder.internal.bouncycastle.mime.MimeParser;
import io.gatling.recorder.internal.bouncycastle.mime.MimeParserProvider;
import io.gatling.recorder.internal.bouncycastle.operator.DigestCalculatorProvider;

public class SMimeParserProvider
    implements MimeParserProvider
{
    private final String defaultContentTransferEncoding;
    private final DigestCalculatorProvider digestCalculatorProvider;

    public SMimeParserProvider(String defaultContentTransferEncoding, DigestCalculatorProvider digestCalculatorProvider)
    {
        this.defaultContentTransferEncoding = defaultContentTransferEncoding;
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public MimeParser createParser(InputStream source)
        throws IOException
    {
        return new BasicMimeParser(new SMimeParserContext(defaultContentTransferEncoding, digestCalculatorProvider),
            SMimeUtils.autoBuffer(source));
    }

    public MimeParser createParser(Headers headers, InputStream source)
        throws IOException
    {
        return new BasicMimeParser(new SMimeParserContext(defaultContentTransferEncoding, digestCalculatorProvider),
            headers, SMimeUtils.autoBuffer(source));
    }
}
