/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.UndefinedParameterType;
import io.cucumber.prettyformatter.SummaryReportWriter;
import io.cucumber.prettyformatter.Theme;
import io.cucumber.query.Repository;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class MessagesToSummaryWriter
implements AutoCloseable {
    private final Repository repository = Repository.builder().feature(Repository.RepositoryFeature.INCLUDE_HOOKS, true).feature(Repository.RepositoryFeature.INCLUDE_GHERKIN_DOCUMENTS, true).feature(Repository.RepositoryFeature.INCLUDE_SUGGESTIONS, true).build();
    private final List<UndefinedParameterType> undefinedParameterTypes = new ArrayList<UndefinedParameterType>();
    private final OutputStream out;
    private final Theme theme;
    private final Function<String, String> uriFormatter;
    private boolean streamClosed = false;

    private MessagesToSummaryWriter(OutputStream out, Theme theme, Function<String, String> uriFormatter) {
        this.out = out;
        this.theme = theme;
        this.uriFormatter = uriFormatter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void write(Envelope envelope) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream closed");
        }
        this.repository.update(envelope);
        envelope.getUndefinedParameterType().ifPresent(this.undefinedParameterTypes::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.streamClosed) {
            return;
        }
        try (SummaryReportWriter writer = new SummaryReportWriter(this.out, this.theme, this.uriFormatter, this.repository, this.undefinedParameterTypes);){
            writer.printSummary();
        }
        finally {
            this.streamClosed = true;
        }
    }

    public static final class Builder {
        private Theme theme = Theme.none();
        private Function<String, String> uriFormatter = Function.identity();

        private Builder() {
        }

        private static Function<String, String> removePrefix(String prefix) {
            return s -> {
                if (s.startsWith(prefix)) {
                    return s.substring(prefix.length());
                }
                return s;
            };
        }

        public Builder theme(Theme theme) {
            this.theme = Objects.requireNonNull(theme);
            return this;
        }

        public Builder removeUriPrefix(String prefix) {
            this.uriFormatter = Builder.removePrefix(Objects.requireNonNull(prefix));
            return this;
        }

        public MessagesToSummaryWriter build(OutputStream out) {
            Objects.requireNonNull(out);
            return new MessagesToSummaryWriter(out, this.theme, this.uriFormatter);
        }
    }
}

