/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.textfield.AbstractNumberField;
import com.vaadin.flow.component.textfield.AbstractNumberFieldI18n;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;

@Tag(value="vaadin-integer-field")
public class ShortField
extends AbstractNumberField<ShortField, Short>
implements HasThemeVariant<TextFieldVariant> {
    private static final SerializableFunction<String, Short> PARSER = (SerializableFunction & Serializable)valueFormClient -> {
        if (valueFormClient == null || valueFormClient.isEmpty()) {
            return null;
        }
        try {
            return Short.parseShort(valueFormClient);
        }
        catch (NumberFormatException e) {
            return null;
        }
    };
    private static final SerializableFunction<Short, String> FORMATTER = (SerializableFunction & Serializable)valueFromModel -> valueFromModel == null ? "" : valueFromModel.toString();

    public ShortField() {
        super(PARSER, FORMATTER, -32768.0, 32767.0);
    }

    public ShortField(String label) {
        this();
        this.setLabel(label);
    }

    public ShortField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public ShortField(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<ShortField, Short>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public ShortField(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<ShortField, Short>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public ShortField(String label, Short initialValue, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<ShortField, Short>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public void setMin(int min) {
        super.setMin((double)min);
    }

    public int getMin() {
        return (int)this.getMinDouble();
    }

    public void setMax(int max) {
        super.setMax((double)max);
    }

    public int getMax() {
        return (int)this.getMaxDouble();
    }

    public void setStep(int step) {
        if (step <= 0) {
            throw new IllegalArgumentException("The step cannot be less or equal to zero.");
        }
        super.setStep((double)step);
    }

    public int getStep() {
        return (int)this.getStepDouble();
    }

    public ShortFieldI18n getI18n() {
        return (ShortFieldI18n)super.getI18n();
    }

    public void setI18n(ShortFieldI18n i18n) {
        super.setI18n((AbstractNumberFieldI18n)i18n);
    }

    public static class ShortFieldI18n
    implements AbstractNumberFieldI18n {
        private String requiredErrorMessage;
        private String badInputErrorMessage;
        private String minErrorMessage;
        private String maxErrorMessage;
        private String stepErrorMessage;

        public String getBadInputErrorMessage() {
            return this.badInputErrorMessage;
        }

        public ShortFieldI18n setBadInputErrorMessage(String errorMessage) {
            this.badInputErrorMessage = errorMessage;
            return this;
        }

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public ShortFieldI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }

        public String getMinErrorMessage() {
            return this.minErrorMessage;
        }

        public ShortFieldI18n setMinErrorMessage(String errorMessage) {
            this.minErrorMessage = errorMessage;
            return this;
        }

        public String getMaxErrorMessage() {
            return this.maxErrorMessage;
        }

        public ShortFieldI18n setMaxErrorMessage(String errorMessage) {
            this.maxErrorMessage = errorMessage;
            return this;
        }

        public String getStepErrorMessage() {
            return this.stepErrorMessage;
        }

        public ShortFieldI18n setStepErrorMessage(String errorMessage) {
            this.stepErrorMessage = errorMessage;
            return this;
        }
    }
}

