/*
 * #%L
 * JMexico :: Model
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2011 - 2012 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

public abstract class ExperimentDesign implements Serializable {

    private static final long serialVersionUID = 7148676296484610658L;

    public static final String PROPERTY_ID = "id";

    public static final String PROPERTY_DATE = "date";

    public static final String PROPERTY_DESCRIPTION = "description";

    public static final String PROPERTY_AUTHOR = "author";

    public static final String PROPERTY_LICENCE = "licence";

    public static final String PROPERTY_FACTOR = "factor";

    protected String id;

    protected Date date;

    protected String description;

    protected String author;

    protected String licence;

    protected Collection<Factor> factor;

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        String oldValue = getId();
        this.id = id;
        firePropertyChange(PROPERTY_ID, oldValue, id);
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        Date oldValue = getDate();
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        String oldValue = getDescription();
        this.description = description;
        firePropertyChange(PROPERTY_DESCRIPTION, oldValue, description);
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        String oldValue = getAuthor();
        this.author = author;
        firePropertyChange(PROPERTY_AUTHOR, oldValue, author);
    }

    public String getLicence() {
        return licence;
    }

    public void setLicence(String licence) {
        String oldValue = getLicence();
        this.licence = licence;
        firePropertyChange(PROPERTY_LICENCE, oldValue, licence);
    }

    public Factor getFactor(int index) {
        Factor o = getChild(factor, index);
        return o;
    }

    public void addFactor(Factor factor) {
        getFactor().add(factor);
    
        firePropertyChange(PROPERTY_FACTOR, null, factor);
    }

    public void addAllFactor(Collection<Factor> factor) {
        getFactor().addAll(factor);
    
        firePropertyChange(PROPERTY_FACTOR, null, factor);
    }

    public boolean removeFactor(Factor factor) {
        boolean  removed = getFactor().remove(factor);
    
        if (removed) {
            firePropertyChange(PROPERTY_FACTOR, factor, null);
      }
    
        return removed;
    }

    public boolean removeAllFactor(Collection<Factor> factor) {
        boolean  removed = getFactor().removeAll(factor);
    
        if (removed) {
            firePropertyChange(PROPERTY_FACTOR, factor, null);
      }
    
        return removed;
    }

    public boolean containsFactor(Factor factor) {
        boolean contains = getFactor().contains(factor);
    
        return contains;
    }

    public boolean containsAllFactor(Collection<Factor> factor) {
        boolean  contains = getFactor().containsAll(factor);
    
        return contains;
    }

    public Collection<Factor> getFactor() {
        return factor;
    }

    public void setFactor(Collection<Factor> factor) {
        Collection<Factor> oldValue = getFactor();
        this.factor = factor;
        firePropertyChange(PROPERTY_FACTOR, oldValue, factor);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }

    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }

} //ExperimentDesign
