package fr.reseaumexico.model;

import fr.reseaumexico.model.event.ScenarioFactorValueListener;
import java.util.Collection;
import java.util.Map;

public abstract class Scenario extends AbstractMexicoBean {

    private static final long serialVersionUID = 7076673858399974965L;

    public static final String PROPERTY_ORDER_NUMBER = "orderNumber";

    public static final String PROPERTY_NAME = "name";

    public static final String PROPERTY_FACTOR_VALUES = "factorValues";

    public static final String PROPERTY_FEATURE = "feature";

    protected int orderNumber;

    protected String name;

    protected Map<Factor, Object> factorValues;

    protected Collection<Feature> feature;

    public int getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(int orderNumber) {
        int oldValue = getOrderNumber();
        this.orderNumber = orderNumber;
        firePropertyChange(PROPERTY_ORDER_NUMBER, oldValue, orderNumber);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        String oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public Map<Factor, Object> getFactorValues() {
        return factorValues;
    }

    public void setFactorValues(Map<Factor, Object> factorValues) {
        Map<Factor, Object> oldValue = getFactorValues();
        this.factorValues = factorValues;
        firePropertyChange(PROPERTY_FACTOR_VALUES, oldValue, factorValues);
    }

    public Feature getFeature(int index) {
        Feature o = getChild(feature, index);
        return o;
    }

    public boolean isFeatureEmpty() {
        return feature == null || feature.isEmpty();
    }

    public int sizeFeature() {
        return feature == null ? 0 : feature.size();
    }

    public void addFeature(Feature feature) {
        getFeature().add(feature);
        firePropertyChange(PROPERTY_FEATURE, null, feature);
    }

    public void addAllFeature(Collection<Feature> feature) {
        getFeature().addAll(feature);
        firePropertyChange(PROPERTY_FEATURE, null, feature);
    }

    public boolean removeFeature(Feature feature) {
        boolean removed = getFeature().remove(feature);
        if (removed) {
            firePropertyChange(PROPERTY_FEATURE, feature, null);
        }
        return removed;
    }

    public boolean removeAllFeature(Collection<Feature> feature) {
        boolean  removed = getFeature().removeAll(feature);
        if (removed) {
            firePropertyChange(PROPERTY_FEATURE, feature, null);
        }
        return removed;
    }

    public boolean containsFeature(Feature feature) {
        boolean contains = getFeature().contains(feature);
        return contains;
    }

    public boolean containsAllFeature(Collection<Feature> feature) {
        boolean  contains = getFeature().containsAll(feature);
        return contains;
    }

    public Collection<Feature> getFeature() {
        return feature;
    }

    public void setFeature(Collection<Feature> feature) {
        Collection<Feature> oldValue = getFeature();
        this.feature = feature;
        firePropertyChange(PROPERTY_FEATURE, oldValue, feature);
    }

    public abstract void setFactorValue(Factor factor, Object value);

    public abstract Object getFactorValue(Factor factor);

    public abstract void addFactorValueListener(ScenarioFactorValueListener factorListener);

    public abstract void removeFactorValueListener(ScenarioFactorValueListener factorListener);

} //Scenario
