/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import fr.ird.t3.entities.user.JdbcConfiguration;
import fr.ird.t3.services.DatabaseService;
import fr.ird.t3.web.validators.T3BaseFieldValidatorSupport;

public class CheckJdbcConnectionValidator
extends T3BaseFieldValidatorSupport {
    public void validateWhenNotSkip(Object object) throws ValidationException {
        if (this.getValidatorContext().hasFieldErrors()) {
            return;
        }
        DatabaseService databaseService = (DatabaseService)this.getFieldValue("databaseService", object);
        String fieldName = this.getFieldName();
        JdbcConfiguration db = (JdbcConfiguration)this.getFieldValue(fieldName, object);
        try {
            databaseService.checkJDBCConnection(db);
        }
        catch (Exception e) {
            this.addFieldError("database.url", this._("t3.error.invalid.jdbc.connexion", new Object[]{e.getMessage()}));
        }
    }

    public String getValidatorType() {
        return "jdbcConnection";
    }
}

