/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.txoj;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionHierarchy;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.txoj.LockList;
import com.arjuna.ats.internal.txoj.LockListIterator;
import com.arjuna.ats.internal.txoj.abstractrecords.CadaverLockRecord;
import com.arjuna.ats.internal.txoj.abstractrecords.LockRecord;
import com.arjuna.ats.internal.txoj.lockstore.BasicLockStore;
import com.arjuna.ats.internal.txoj.lockstore.BasicPersistentLockStore;
import com.arjuna.ats.internal.txoj.semaphore.BasicSemaphore;
import com.arjuna.ats.txoj.Lock;
import com.arjuna.ats.txoj.LockConflictManager;
import com.arjuna.ats.txoj.common.txojPropertyManager;
import com.arjuna.ats.txoj.exceptions.LockStoreException;
import com.arjuna.ats.txoj.lockstore.LockStore;
import com.arjuna.ats.txoj.logging.txojLogger;
import com.arjuna.ats.txoj.semaphore.Semaphore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class LockManager
extends StateManager {
    public static final int defaultRetry = 100;
    public static final int defaultSleepTime = 250;
    public static final int waitTotalTimeout = -100;
    private String lockStoreType = txojPropertyManager.getTxojEnvironmentBean().getLockStoreType();
    private String systemKey;
    private LockList locksHeld;
    private final Object locksHeldLockObject = new Object();
    private LockStore lockStore;
    private boolean stateLoaded;
    private boolean hasBeenLocked;
    private boolean objectLocked;
    private Semaphore mutex;
    private LockConflictManager conflictManager;
    private static final int DOZE_TIME = 1000000;
    private static boolean nestedLocking = true;

    @Override
    public void finalize() throws Throwable {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(2L, 4L, 2L, "LockManager.finalize()");
        }
        boolean doSignal = false;
        this.cleanUp();
        if (this.mutex != null && this.mutex.lock() == 0) {
            doSignal = true;
        }
        this.locksHeld = null;
        this.lockStore = null;
        this.conflictManager = null;
        if (doSignal) {
            this.mutex.unlock();
        }
        this.mutex = null;
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean propagate(Uid from, Uid to) {
        Object object;
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 2L, "LockManager::propagate(" + from + ", " + to + ")");
        }
        boolean result = false;
        int retryCount = 10;
        do {
            try {
                object = this.locksHeldLockObject;
                synchronized (object) {
                    if (this.loadState()) {
                        LockList oldlist = this.locksHeld;
                        Lock current = null;
                        this.locksHeld = new LockList();
                        if (this.locksHeld != null) {
                            while ((current = oldlist.pop()) != null) {
                                if (current.getCurrentOwner().equals(from)) {
                                    current.propagate();
                                }
                                if (this.locksHeld.insert(current)) continue;
                                current = null;
                            }
                            oldlist = null;
                            result = true;
                        } else {
                            this.freeState();
                            throw new NullPointerException();
                        }
                    }
                    if (result) {
                        result = this.unloadState();
                    }
                }
            }
            catch (NullPointerException e) {
                result = false;
            }
            if (result) continue;
            try {
                Thread.sleep(1000000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (!result && --retryCount > 0);
        if (!result) {
            if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_1");
            }
            object = this.locksHeldLockObject;
            synchronized (object) {
                this.freeState();
            }
        }
        return result;
    }

    public final boolean releaseAll(Uid actionUid) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 2L, "LockManager::releaseAll(" + actionUid + ")");
        }
        return this.doRelease(actionUid, true);
    }

    public final boolean releaselock(Uid lockUid) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 2L, "LockManager::releaseLock(" + lockUid + ")");
        }
        return this.doRelease(lockUid, false);
    }

    public final int setlock(Lock toSet) {
        return this.setlock(toSet, 100, 250);
    }

    public final int setlock(Lock toSet, int retry) {
        return this.setlock(toSet, retry, 250);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setlock(Lock toSet, int retry, int sleepTime) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 2L, "LockManager::setlock(" + toSet + ", " + retry + ", " + sleepTime + ")");
        }
        int conflict = 0;
        int returnStatus = 1;
        LockRecord newLockR = null;
        boolean modifyRequired = false;
        BasicAction currAct = null;
        if (toSet == null) {
            if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_2");
            }
            return 1;
        }
        currAct = BasicAction.Current();
        if (currAct != null) {
            ActionHierarchy ah = currAct.getHierarchy();
            if (ah != null) {
                toSet.changeHierarchy(ah);
            } else {
                if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                    txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_3");
                }
                toSet = null;
                return 1;
            }
        }
        if (super.loadObjectState()) {
            super.setupStore();
        }
        while (conflict == 0 && (retry >= 0 || retry == -100)) {
            Object syncObject;
            Object object = syncObject = currAct == null ? this.getMutex() : currAct;
            synchronized (object) {
                Object object2 = this.locksHeldLockObject;
                synchronized (object2) {
                    conflict = 0;
                    if (this.loadState()) {
                        conflict = this.lockConflict(toSet);
                    } else if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                        txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_4");
                    }
                    if (conflict != 0) {
                        modifyRequired = toSet.modifiesObject();
                        if (super.activate()) {
                            returnStatus = 0;
                            if (conflict == 1) {
                                int lrStatus = 2;
                                if (currAct != null && (lrStatus = currAct.add(newLockR = new LockRecord(this, !modifyRequired, currAct))) != 2) {
                                    newLockR = null;
                                    if (lrStatus == 3) {
                                        returnStatus = 1;
                                    }
                                }
                                if (returnStatus == 0) {
                                    this.locksHeld.insert(toSet);
                                }
                            }
                        } else {
                            if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                                txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_5");
                            }
                            returnStatus = 1;
                        }
                    }
                    if (returnStatus == 0 && conflict == 1) {
                        if (!this.unloadState()) {
                            if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                                txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_6");
                            }
                            returnStatus = 1;
                        }
                    } else {
                        this.freeState();
                    }
                    if (returnStatus == 0 && modifyRequired) {
                        if (super.modified()) {
                            this.hasBeenLocked = true;
                        } else {
                            conflict = 0;
                            returnStatus = 1;
                        }
                    }
                    if (conflict == 0) {
                        this.freeState();
                    }
                }
                if (conflict == 0) {
                    if (retry != 0) {
                        if (sleepTime > 0) {
                            sleepTime -= this.conflictManager.wait(retry, sleepTime);
                        } else {
                            retry = 0;
                        }
                    }
                    if (retry != -100) {
                        --retry;
                    }
                }
            }
        }
        return returnStatus;
    }

    @Override
    public void print(PrintWriter strm) {
        LockListIterator next = new LockListIterator(this.locksHeld);
        strm.println("LocalLockManager for object " + this.get_uid());
        if (!this.stateLoaded) {
            strm.println("No loaded state");
        } else if (this.locksHeld != null) {
            Lock current;
            strm.println("\tCurrently holding : " + this.locksHeld.entryCount() + " locks");
            while ((current = next.iterate()) != null) {
                current.print(strm);
            }
        } else {
            strm.println("Currently holding : 0 locks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printState(PrintWriter strm) {
        Object object = this.locksHeldLockObject;
        synchronized (object) {
            boolean iDeleteState = false;
            if (!this.stateLoaded) {
                this.loadState();
                iDeleteState = true;
            }
            this.print(strm);
            if (iDeleteState) {
                this.freeState();
            }
        }
    }

    @Override
    public String type() {
        return "StateManager/LockManager";
    }

    protected LockManager(Uid storeUid) {
        this(storeUid, 1, 0);
    }

    protected LockManager(Uid storeUid, int ot) {
        this(storeUid, ot, 0);
    }

    protected LockManager(Uid storeUid, int ot, int om) {
        super(storeUid, ot, om);
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(1L, 2L, 2L, "LockManager::LockManager(" + storeUid + ")");
        }
        this.systemKey = null;
        this.locksHeld = new LockList();
        this.lockStore = null;
        this.mutex = null;
        this.stateLoaded = false;
        this.hasBeenLocked = false;
        this.objectLocked = false;
        this.conflictManager = new LockConflictManager();
    }

    protected LockManager() {
        this(0);
    }

    protected LockManager(int ot) {
        this(ot, 0);
    }

    protected LockManager(int ot, int om) {
        super(ot, om);
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(1L, 2L, 2L, "LockManager::LockManager(" + ot + ")");
        }
        this.systemKey = null;
        this.locksHeld = new LockList();
        this.lockStore = null;
        this.mutex = null;
        this.stateLoaded = false;
        this.hasBeenLocked = false;
        this.objectLocked = false;
        this.conflictManager = new LockConflictManager();
    }

    @Override
    protected void terminate() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 2L, 2L, "LockManager::terminate() for object-id " + this.get_uid());
        }
        this.cleanUp();
        super.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanUp() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::cleanUp() for object-id " + this.get_uid());
        }
        if (this.hasBeenLocked) {
            if (this.objectModel == 1 && this.systemKey == null) {
                this.initialise();
            }
            Hashtable hashtable = this.usingActions;
            synchronized (hashtable) {
                if (this.usingActions != null) {
                    Enumeration e = this.usingActions.keys();
                    while (e.hasMoreElements()) {
                        BasicAction action = (BasicAction)e.nextElement();
                        while (action != null) {
                            CadaverLockRecord A = new CadaverLockRecord(this.lockStore, this, action);
                            if (action.add(A) == 2) continue;
                            A = null;
                        }
                    }
                }
            }
            this.hasBeenLocked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doRelease(Uid u, boolean all) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::doRelease(" + u + ", " + all + ")");
        }
        Lock previous = null;
        Lock current = null;
        boolean deleted = false;
        boolean result = false;
        int retryCount = 10;
        boolean loaded = false;
        do {
            Object object = this.locksHeldLockObject;
            synchronized (object) {
                if (this.loadState()) {
                    loaded = true;
                    LockListIterator next = new LockListIterator(this.locksHeld);
                    previous = null;
                    while ((current = next.iterate()) != null) {
                        Uid checkUid = null;
                        checkUid = all ? current.getCurrentOwner() : current.get_uid();
                        if (u.equals(checkUid)) {
                            this.locksHeld.forgetNext(previous);
                            current = null;
                            deleted = true;
                            if (all) continue;
                            break;
                        }
                        previous = current;
                    }
                    result = true;
                } else {
                    this.freeState();
                    result = false;
                }
            }
            if (result) continue;
            try {
                Thread.sleep(1000000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (!result && --retryCount > 0);
        boolean releasedOK = false;
        if (!loaded) {
            if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_7");
            }
        } else {
            if (!deleted && txojLogger.aitLogger.isDebugEnabled()) {
                txojLogger.aitLogger.debug(16L, 1L, 2L, " *** CANNOT locate locks  ***");
            }
            retryCount = 10;
            Object object = this.locksHeldLockObject;
            synchronized (object) {
                do {
                    if (!this.unloadState()) {
                        if (!txojLogger.aitLoggerI18N.isWarnEnabled()) continue;
                        txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_8");
                        continue;
                    }
                    releasedOK = true;
                } while (--retryCount > 0 && !releasedOK);
            }
        }
        this.conflictManager.signal();
        return releasedOK;
    }

    private final void freeState() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::freeState()");
        }
        if (this.mutex != null) {
            if (this.objectModel != 0) {
                while (this.locksHeld.pop() != null) {
                }
                this.stateLoaded = false;
                if (this.objectLocked) {
                    this.objectLocked = false;
                    this.mutex.unlock();
                }
            } else {
                this.stateLoaded = false;
            }
        } else {
            this.stateLoaded = false;
            this.objectLocked = false;
        }
    }

    private final boolean initialise() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::initialise()");
        }
        boolean result = false;
        if (this.systemKey == null) {
            this.systemKey = this.type();
            if (this.mutex == null) {
                this.mutex = new BasicSemaphore(this.systemKey);
            }
            if (this.mutex != null) {
                if (this.mutex.lock() == 0 && this.lockStore == null) {
                    try {
                        this.lockStore = this.lockStoreType.equals(BasicLockStore.class.getName()) ? new BasicLockStore(this.systemKey) : new BasicPersistentLockStore(this.systemKey);
                    }
                    catch (Exception ex) {
                        this.lockStore = null;
                    }
                }
                this.mutex.unlock();
            }
        }
        result = this.lockStore != null;
        return result;
    }

    private final boolean isAncestorOf(Lock heldLock) {
        BasicAction action;
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::isAncestorOf(" + heldLock.getCurrentOwner() + ")");
        }
        if ((action = BasicAction.Current()) == null) {
            return false;
        }
        return action.isAncestor(heldLock.getCurrentOwner());
    }

    private final boolean loadState() {
        block18: {
            if (txojLogger.aitLogger.isDebugEnabled()) {
                txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::loadState()");
            }
            if (this.objectModel == 0) {
                this.stateLoaded = true;
                return true;
            }
            InputObjectState S = null;
            if (this.systemKey == null && !this.initialise()) {
                return false;
            }
            if (this.mutex == null || this.mutex.tryLock() == 2) {
                return false;
            }
            this.stateLoaded = false;
            this.objectLocked = true;
            try {
                S = this.lockStore.read_state(this.get_uid(), this.type());
                if (S != null) {
                    Uid u = null;
                    Lock current = null;
                    int count = 0;
                    try {
                        count = S.unpackInt();
                        boolean cleanLoad = true;
                        if (txojLogger.aitLogger.isDebugEnabled()) {
                            txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::loadState() loading " + count + " lock(s)");
                        }
                        for (int i = 0; i < count && cleanLoad; ++i) {
                            try {
                                u = UidHelper.unpackFrom(S);
                                current = new Lock(u);
                                if (current != null) {
                                    if (current.restore_state(S, 1)) {
                                        this.locksHeld.push(current);
                                        continue;
                                    }
                                    current = null;
                                    cleanLoad = false;
                                    continue;
                                }
                                cleanLoad = false;
                                continue;
                            }
                            catch (IOException e) {
                                cleanLoad = false;
                            }
                        }
                        if (cleanLoad) {
                            this.stateLoaded = true;
                        } else {
                            while ((current = this.locksHeld.pop()) != null) {
                                current = null;
                            }
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    S = null;
                    break block18;
                }
                this.stateLoaded = true;
            }
            catch (LockStoreException e) {
                if (!txojLogger.aitLogger.isWarnEnabled()) break block18;
                txojLogger.aitLogger.warn(e);
            }
        }
        return this.stateLoaded;
    }

    private final int lockConflict(Lock otherLock) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::lockConflict(" + otherLock.get_uid() + ")");
        }
        boolean matching = false;
        Lock heldLock = null;
        LockListIterator next = new LockListIterator(this.locksHeld);
        while ((heldLock = next.iterate()) != null) {
            if (heldLock.conflictsWith(otherLock)) {
                if (nestedLocking) {
                    if (this.isAncestorOf(heldLock)) continue;
                    return 0;
                }
                return 0;
            }
            if (!heldLock.equals(otherLock)) continue;
            matching = true;
        }
        return matching ? 2 : 1;
    }

    private final boolean unloadState() {
        boolean unloadOk;
        block19: {
            if (txojLogger.aitLogger.isDebugEnabled()) {
                txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::unloadState()");
            }
            if (this.objectModel == 0) {
                this.stateLoaded = false;
                return true;
            }
            unloadOk = false;
            Lock current = null;
            String otype = this.type();
            Uid u = this.get_uid();
            OutputObjectState S = new OutputObjectState(u, otype);
            int lockCount = this.locksHeld.entryCount();
            if (txojLogger.aitLogger.isDebugEnabled()) {
                txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::unloadState() unloading " + lockCount + " lock(s)");
            }
            if (lockCount == 0) {
                if (this.lockStore.remove_state(u, otype)) {
                    unloadOk = true;
                } else if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                    txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_10", new Object[]{u, otype});
                }
            } else {
                try {
                    S.packInt(lockCount);
                    unloadOk = true;
                    while ((current = this.locksHeld.pop()) != null) {
                        UidHelper.packInto(current.get_uid(), S);
                        if (!current.save_state(S, 1)) {
                            if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                                txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_11", new Object[]{current});
                            }
                            unloadOk = false;
                        }
                        current = null;
                    }
                    if (unloadOk) {
                        unloadOk = false;
                        if (S.valid() && this.lockStore.write_committed(u, otype, S)) {
                            unloadOk = true;
                        } else if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                            txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_12", new Object[]{u, otype});
                        }
                    }
                }
                catch (IOException e) {
                    unloadOk = false;
                    if (!txojLogger.aitLoggerI18N.isWarnEnabled()) break block19;
                    txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_13", new Object[]{u, otype});
                }
            }
        }
        this.stateLoaded = false;
        if (this.objectLocked) {
            this.objectLocked = false;
            if (this.mutex != null) {
                this.mutex.unlock();
            }
        }
        return unloadOk;
    }

    static {
        nestedLocking = txojPropertyManager.getTxojEnvironmentBean().isAllowNestedLocking();
    }
}

