/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.CoreContainer;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyTreeNodeHelper;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittyExtensionStorage;
import org.nuiton.wikitty.storage.WikittySearchEngine;
import org.nuiton.wikitty.storage.solr.AttachmentInTree;
import org.nuiton.wikitty.storage.solr.FieldModifier;
import org.nuiton.wikitty.storage.solr.Restriction2Solr;
import org.nuiton.wikitty.storage.solr.SolrResource;
import org.nuiton.wikitty.storage.solr.SolrUtil;

public class WikittySearchEngineSolr
implements WikittySearchEngine {
    private static final Log log = LogFactory.getLog(WikittySearchEngineSolr.class);
    private static final TimeLog timeLog = new TimeLog(WikittySearchEngineSolr.class);
    protected SolrServer solrServer;
    protected FieldModifier fieldModifier;
    protected SolrResource solrResource;

    public WikittySearchEngineSolr(ApplicationConfig config, WikittyExtensionStorage extensionStorage) {
        if (config != null) {
            String solrDataDirKey;
            String solrDataDir;
            String solrDirFactoryKey = WikittyConfigOption.WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_FACTORY.getKey();
            String solrDirFactory = config.getOption(solrDirFactoryKey);
            if (solrDirFactory != null) {
                System.setProperty(solrDirFactoryKey, solrDirFactory);
            }
            if (solrDirFactory != null && !solrDirFactory.contains("RAMDirectoryFactory") && (solrDataDir = config.getOption(solrDataDirKey = WikittyConfigOption.WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_DATA.getKey())) != null) {
                File file = new File(solrDataDir);
                if (!file.exists() && !file.mkdirs()) {
                    throw new WikittyException(String.format("Can't create directory '%s'", solrDataDir));
                }
                log.info((Object)String.format("Use SolR directory '%s'", solrDataDir));
                System.setProperty(solrDataDirKey, solrDataDir);
            }
        }
        try {
            CoreContainer.Initializer initializer = new CoreContainer.Initializer();
            CoreContainer coreContainer = initializer.initialize();
            this.solrServer = new EmbeddedSolrServer(coreContainer, "");
            this.fieldModifier = new FieldModifier(extensionStorage);
            this.solrResource = new SolrResource(this.solrServer);
        }
        catch (Exception eee) {
            throw new WikittyException("SolR initialization error", (Throwable)eee);
        }
    }

    public void clear(WikittyTransaction transaction) {
        try {
            this.solrResource.init();
            this.solrServer.deleteByQuery("*:*");
        }
        catch (Exception eee) {
            throw new WikittyException("Error during clearing SolR data", (Throwable)eee);
        }
    }

    public void store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
        long startTime = TimeLog.getTime();
        try {
            SolrInputDocument doc;
            SolrDocument oldDoc;
            Wikitty w;
            this.solrResource.init();
            HashMap<String, Wikitty> allWikitties = new HashMap<String, Wikitty>();
            HashSet<String> dirtyObject = new HashSet<String>();
            HashSet<String> dirtyParent = new HashSet<String>();
            HashSet<String> dirtyParentParentId = new HashSet<String>();
            for (Wikitty w2 : wikitties) {
                allWikitties.put(w2.getId(), w2);
                if (!force && w2.getDirty().isEmpty() && !WikittyUtil.versionGreaterThan((String)"1", (String)w2.getVersion())) continue;
                dirtyObject.add(w2.getId());
                if (!WikittyTreeNodeHelper.hasExtension((Wikitty)w2) || !force && !w2.getDirty().contains("WikittyTreeNode.parent") && null != WikittyTreeNodeHelper.getParent((Wikitty)w2)) continue;
                dirtyParent.add(w2.getId());
                String parent = WikittyTreeNodeHelper.getParent((Wikitty)w2);
                if (parent == null) continue;
                dirtyParentParentId.add(parent);
            }
            Map<String, SolrDocument> dirtyObjectDoc = SolrUtil.findAllById(this.solrServer, dirtyObject);
            Map<String, SolrDocument> dirtyParentDoc = SolrUtil.findAllByParents(this.solrServer, dirtyParent);
            Map<String, SolrDocument> parents = SolrUtil.findAllById(this.solrServer, dirtyParentParentId);
            AttachmentInTree attachmentInTree = new AttachmentInTree();
            for (String id : dirtyObject) {
                w = (Wikitty)allWikitties.get(id);
                oldDoc = dirtyObjectDoc.get(id);
                doc = this.createIndexDocument(w);
                if (oldDoc != null) {
                    SolrUtil.copySolrDocument(oldDoc, doc, "#tree.attached..*");
                    if (WikittyTreeNodeHelper.hasExtension((Wikitty)w) && !dirtyParentDoc.containsKey(id)) {
                        SolrUtil.copySolrDocument(oldDoc, doc, "#tree..*");
                        Set newAtt = WikittyTreeNodeHelper.getAttachment((Wikitty)w);
                        Collection<String> oldAtt = SolrUtil.getStringFieldValues(oldDoc, "WikittyTreeNode.attachment", FieldType.TYPE.WIKITTY);
                        HashSet<String> toRemove = new HashSet<String>();
                        if (oldAtt != null) {
                            toRemove.addAll(oldAtt);
                        }
                        if (newAtt != null) {
                            toRemove.removeAll(newAtt);
                        }
                        attachmentInTree.remove(id, toRemove);
                        HashSet<String> toAdd = new HashSet<String>();
                        if (newAtt != null) {
                            toAdd.addAll(newAtt);
                        }
                        if (oldAtt != null) {
                            toAdd.removeAll(oldAtt);
                        }
                        attachmentInTree.add(id, toAdd);
                    }
                }
                this.solrResource.addDoc(id, doc);
            }
            dirtyParent.addAll(dirtyParentDoc.keySet());
            for (String id : dirtyParent) {
                w = (Wikitty)allWikitties.get(id);
                oldDoc = dirtyParentDoc.get(id);
                doc = this.solrResource.getAddedDoc(id);
                if (w == null) {
                    doc = new SolrInputDocument();
                    SolrUtil.copySolrDocumentExcludeSomeField(oldDoc, doc, "#tree..*");
                    this.addTreeIndexField(this.solrResource, doc, parents);
                    attachmentInTree.remove(oldDoc);
                    attachmentInTree.add(oldDoc);
                } else if (oldDoc == null) {
                    this.addTreeIndexField(this.solrResource, doc, parents);
                    attachmentInTree.add(w);
                } else {
                    this.addTreeIndexField(this.solrResource, doc, parents);
                    attachmentInTree.remove(oldDoc);
                    attachmentInTree.add(w);
                }
                this.solrResource.addDoc(id, doc);
            }
            this.addTreeIndexField(this.solrResource, null, attachmentInTree);
        }
        catch (Exception eee) {
            throw new WikittyException("Can't store wikitty", (Throwable)eee);
        }
        timeLog.log(startTime, "store", String.format("nb %s in force mode %s", wikitties.size(), force));
    }

    public void delete(WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        long startTime = TimeLog.getTime();
        try {
            SolrDocument doc;
            this.solrResource.init();
            AttachmentInTree attachmentInTree = new AttachmentInTree();
            Map<String, SolrDocument> removed = SolrUtil.findAllById(this.solrServer, ids);
            HashMap<String, SolrDocument> treeNodeRemoved = new HashMap<String, SolrDocument>();
            HashSet<String> treeNodeAttachmentRemovedId = new HashSet<String>();
            for (Map.Entry<String, SolrDocument> e : removed.entrySet()) {
                String id = e.getKey();
                SolrDocument doc2 = e.getValue();
                if (doc2.containsKey((Object)"#tree.root")) {
                    treeNodeRemoved.put(id, doc2);
                    attachmentInTree.remove(doc2);
                }
                Set<String> treeNodeIds = SolrUtil.getAttachedTreeNode(doc2);
                treeNodeAttachmentRemovedId.addAll(treeNodeIds);
                this.solrResource.deleteDoc(id);
            }
            treeNodeAttachmentRemovedId.removeAll(ids);
            if (treeNodeAttachmentRemovedId.size() > 0) {
                Map<String, SolrDocument> treeNodeAttachmentRemoved = SolrUtil.findAllById(this.solrServer, treeNodeAttachmentRemovedId);
                for (Map.Entry<String, SolrDocument> e : treeNodeAttachmentRemoved.entrySet()) {
                    String id = e.getKey();
                    doc = e.getValue();
                    SolrInputDocument newDoc = new SolrInputDocument();
                    String field = SolrUtil.getSolrFieldName("WikittyTreeNode.attachment", FieldType.TYPE.WIKITTY);
                    SolrUtil.copySolrDocumentExcludeSomeField(doc, newDoc, field);
                    Collection<String> atts = SolrUtil.getStringFieldValues(doc, field);
                    HashSet<String> newAtts = new HashSet<String>(atts);
                    newAtts.removeAll(ids);
                    if (newAtts.isEmpty()) {
                        newAtts = null;
                    }
                    this.addToIndexDocument(newDoc, FieldType.TYPE.WIKITTY, field, newAtts, true);
                    this.solrResource.addDoc(id, newDoc);
                }
            }
            if (treeNodeRemoved != null && treeNodeRemoved.size() > 0) {
                Map<String, SolrDocument> treeNodeParentRemoved = SolrUtil.findAllByParents(this.solrServer, ids);
                treeNodeParentRemoved.keySet().removeAll(treeNodeRemoved.keySet());
                for (Map.Entry<String, SolrDocument> e : treeNodeParentRemoved.entrySet()) {
                    SolrDocument oldDoc = e.getValue();
                    doc = new SolrInputDocument();
                    SolrUtil.copySolrDocumentExcludeSomeField(oldDoc, (SolrInputDocument)doc, "#tree..*");
                    this.addTreeIndexField(this.solrResource, (SolrInputDocument)doc, treeNodeParentRemoved);
                    attachmentInTree.remove(oldDoc);
                    attachmentInTree.add((SolrInputDocument)doc);
                }
                attachmentInTree.clean(ids);
                this.addTreeIndexField(this.solrResource, treeNodeParentRemoved, attachmentInTree);
            }
        }
        catch (Exception eee) {
            throw new WikittyException("Can't delete wikitty in index", (Throwable)eee);
        }
        timeLog.log(startTime, "delete", String.format("nb %s", ids.size()));
    }

    protected void addTreeIndexField(SolrResource solrResource, SolrInputDocument doc, Map<String, SolrDocument> tree) {
        HashSet<String> parents = new HashSet<String>();
        String root = null;
        String treeNodeId = SolrUtil.getStringFieldValue(doc, "#id");
        String parentId = treeNodeId;
        if (parentId == null) {
            throw new WikittyException("parentId is null, but this must be impossible");
        }
        parents.add(parentId);
        while (root == null) {
            String nextParentId = null;
            SolrInputDocument parentDoc = solrResource.getAddedDoc(parentId);
            if (parentDoc != null) {
                if (parentDoc.containsKey((Object)"#tree.root")) {
                    root = SolrUtil.getStringFieldValue(parentDoc, "#tree.root");
                    Collection<String> p = SolrUtil.getStringFieldValues(parentDoc, "#tree.parents");
                    parents.addAll(p);
                    break;
                }
                nextParentId = SolrUtil.getStringFieldValue(parentDoc, "WikittyTreeNode.parent", FieldType.TYPE.WIKITTY);
            } else {
                SolrDocument oldParentDoc = tree.get(parentId);
                if (oldParentDoc != null) {
                    if (oldParentDoc.containsKey((Object)"#tree.root")) {
                        root = SolrUtil.getStringFieldValue(oldParentDoc, "#tree.root");
                        Collection<String> p = SolrUtil.getStringFieldValues(oldParentDoc, "#tree.parents");
                        parents.addAll(p);
                        break;
                    }
                    nextParentId = SolrUtil.getStringFieldValue(oldParentDoc, "WikittyTreeNode.parent", FieldType.TYPE.WIKITTY);
                }
            }
            if (nextParentId != null) {
                if (parents.contains(nextParentId)) {
                    log.error((Object)String.format("Tree with TreeNode '%s' have loop at node %s->%s all parents are %s. Set root with last valide parent '%s'", treeNodeId, parentId, nextParentId, parents, parentId));
                    root = parentId;
                    continue;
                }
                parents.add(nextParentId);
                parentId = nextParentId;
                continue;
            }
            root = parentId;
        }
        doc.removeField("#tree.root");
        doc.removeField("#tree.parents");
        doc.removeField("#tree.depth");
        doc.addField("#tree.root", (Object)root);
        doc.addField("#tree.depth", (Object)parents.size());
        for (String id : parents) {
            doc.addField("#tree.parents", (Object)id);
        }
    }

    protected void addTreeIndexField(SolrResource solrResource, Map<String, SolrDocument> tree, AttachmentInTree attachmentInTree) {
        if (attachmentInTree.size() > 0) {
            Map<String, SolrDocument> attachments = SolrUtil.findAllById(this.solrServer, attachmentInTree.getAll());
            for (String treeNodeId : attachmentInTree.getRemoved().keySet()) {
                for (String attId : attachmentInTree.getRemoved().get(treeNodeId)) {
                    SolrDocument oldDoc = attachments.get(attId);
                    SolrInputDocument doc = solrResource.getAddedDoc(attId);
                    if (oldDoc == null && doc == null) continue;
                    if (doc == null) {
                        doc = new SolrInputDocument();
                        SolrUtil.copySolrDocument(oldDoc, doc, new String[0]);
                        solrResource.addDoc(attId, doc);
                    }
                    doc.remove((Object)("#tree.attached." + treeNodeId));
                }
            }
            for (String treeNodeId : attachmentInTree.getAdded().keySet()) {
                Collection<String> treeNodeParents = null;
                SolrInputDocument treeNodeDoc = solrResource.getAddedDoc(treeNodeId);
                if (treeNodeDoc != null) {
                    treeNodeParents = SolrUtil.getStringFieldValues(treeNodeDoc, "#tree.parents");
                } else if (tree != null) {
                    SolrDocument doc = tree.get(treeNodeId);
                    treeNodeParents = SolrUtil.getStringFieldValues(doc, "#tree.parents");
                } else {
                    log.error((Object)"SolR doc not found in Transaction or in tree.This is a bug !!!");
                }
                for (String attId : attachmentInTree.getAdded().get(treeNodeId)) {
                    SolrDocument oldDoc = attachments.get(attId);
                    SolrInputDocument doc = solrResource.getAddedDoc(attId);
                    if (oldDoc == null && doc == null) {
                        doc = new SolrInputDocument();
                        this.addToIndexDocument(doc, null, "#id", attId, true);
                    } else if (doc == null) {
                        doc = new SolrInputDocument();
                        SolrUtil.copySolrDocument(oldDoc, doc, new String[0]);
                        solrResource.addDoc(attId, doc);
                    }
                    doc.removeField("#tree.attached." + treeNodeId);
                    for (String id : treeNodeParents) {
                        doc.addField("#tree.attached." + treeNodeId, (Object)id);
                    }
                }
            }
        }
    }

    public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria) {
        try {
            String facetName;
            List sortDescending;
            Restriction2Solr restriction2Solr = new Restriction2Solr(transaction, this.fieldModifier);
            String queryString = restriction2Solr.toSolr(criteria.getRestriction(), this.solrServer);
            SolrQuery query = new SolrQuery("{!wikitty}" + queryString);
            int firstIndex = criteria.getFirstIndex();
            int endIndex = criteria.getEndIndex();
            query.setStart(Integer.valueOf(firstIndex));
            int nbRows = endIndex == -1 ? Integer.MAX_VALUE - firstIndex : endIndex - firstIndex + 1;
            query.setRows(Integer.valueOf(nbRows));
            List sortAscending = criteria.getSortAscending();
            if (sortAscending != null) {
                for (String sort : sortAscending) {
                    String tranform = this.fieldModifier.convertToSolr(transaction, sort);
                    tranform = tranform + "_sortable";
                    query.addSortField(tranform, SolrQuery.ORDER.asc);
                }
            }
            if ((sortDescending = criteria.getSortDescending()) != null) {
                for (String sort : sortDescending) {
                    String tranform = this.fieldModifier.convertToSolr(transaction, sort);
                    tranform = tranform + "_sortable";
                    query.addSortField(tranform, SolrQuery.ORDER.desc);
                }
            }
            List facetField = criteria.getFacetField();
            List facetCriteria = criteria.getFacetCriteria();
            HashMap<String, String> facetQueryToName = new HashMap<String, String>();
            if (facetField != null && !facetField.isEmpty() || facetCriteria != null && !facetCriteria.isEmpty()) {
                query.setFacet(true);
                query.setFacetMinCount(1);
                if (facetField != null) {
                    for (String fqfieldName : facetField) {
                        String tranform = this.fieldModifier.convertToSolr(transaction, fqfieldName);
                        query.addFacetField(new String[]{tranform});
                    }
                }
                if (facetCriteria != null) {
                    for (Criteria facet : facetCriteria) {
                        String queryFacet = restriction2Solr.toSolr(facet.getRestriction(), this.solrServer);
                        facetQueryToName.put(queryFacet, facet.getName());
                        query.addFacetQuery(queryFacet);
                    }
                }
            }
            QueryResponse resp = SolrUtil.executeQuery(this.solrServer, query);
            SolrDocumentList solrResults = resp.getResults();
            HashMap facets = new HashMap();
            if (facetField != null && !facetField.isEmpty()) {
                for (FacetField facetField2 : resp.getFacetFields()) {
                    facetName = this.fieldModifier.convertToField(transaction, facetField2.getName());
                    ArrayList<FacetTopic> topics = new ArrayList<FacetTopic>();
                    if (facetField2.getValues() != null) {
                        for (FacetField.Count value : facetField2.getValues()) {
                            String topicName = value.getName();
                            int topicCount = (int)value.getCount();
                            FacetTopic topic = new FacetTopic(facetName, topicName, topicCount);
                            topics.add(topic);
                        }
                    }
                    facets.put(facetName, topics);
                }
            }
            if (facetCriteria != null && !facetCriteria.isEmpty()) {
                for (Map.Entry entry : resp.getFacetQuery().entrySet()) {
                    facetName = (String)entry.getKey();
                    if (null != facetQueryToName.get(facetName)) {
                        facetName = (String)facetQueryToName.get(facetName);
                    }
                    Integer count = (Integer)entry.getValue();
                    ArrayList<FacetTopic> topics = new ArrayList<FacetTopic>();
                    FacetTopic topic = new FacetTopic(facetName, facetName, count.intValue());
                    topics.add(topic);
                    facets.put(facetName, topics);
                }
            }
            ArrayList<String> ids = new ArrayList<String>(solrResults.size());
            for (SolrDocument doc : solrResults) {
                String id = SolrUtil.getStringFieldValue(doc, "#id");
                ids.add(id);
            }
            int n = (int)resp.getResults().getNumFound();
            PagedResult result = new PagedResult(firstIndex, n, queryString, facets, ids);
            return result;
        }
        catch (SolrServerException eee) {
            throw new WikittyException(String.format("Error during find of criteria '%s'", criteria), (Throwable)eee);
        }
    }

    public TreeNodeResult<String> findAllChildrenCount(WikittyTransaction transaction, String wikittyId, int depth, boolean count, Criteria filter) {
        try {
            TreeNodeResult result = null;
            SolrDocument doc = SolrUtil.findById(this.solrServer, wikittyId);
            if (doc != null) {
                if (doc.containsKey((Object)"#tree.depth")) {
                    String parentId;
                    String id;
                    Criteria attCriteria;
                    PagedResult<String> attSearch;
                    List topics;
                    Search treeSearch = Search.query().and().eq("#tree.parents", wikittyId);
                    if (depth >= 0) {
                        Integer d = SolrUtil.getIntFieldValue(doc, "#tree.depth");
                        treeSearch = treeSearch.bw("#tree.depth", String.valueOf(d), String.valueOf(d + depth));
                    }
                    Criteria treeCriteria = treeSearch.criteria();
                    Restriction2Solr restriction2Solr = new Restriction2Solr(transaction, this.fieldModifier);
                    String queryString = restriction2Solr.toSolr(treeCriteria.getRestriction(), this.solrServer);
                    SolrQuery query = new SolrQuery("{!wikitty}" + queryString);
                    QueryResponse resp = SolrUtil.executeQuery(this.solrServer, query);
                    SolrDocumentList solrResults = resp.getResults();
                    HashMap<String, Integer> counts = new HashMap<String, Integer>();
                    if (count && (topics = (attSearch = this.findAllByCriteria(transaction, attCriteria = Search.query((Criteria)filter).eq("#tree.attached-all", wikittyId).criteria().setFirstIndex(0).setEndIndex(0).addFacetField("#tree.attached-all"))).getTopic("#tree.attached-all")) != null) {
                        for (FacetTopic topic : topics) {
                            String topicName = topic.getTopicName();
                            int topicCount = topic.getCount();
                            counts.put(topicName, topicCount);
                        }
                    }
                    HashMap<String, TreeNodeResult> allTreeNodeResult = new HashMap<String, TreeNodeResult>();
                    HashMap<String, String> childParent = new HashMap<String, String>();
                    for (SolrDocument d : solrResults) {
                        id = SolrUtil.getStringFieldValue(d, "#id");
                        parentId = SolrUtil.getStringFieldValue(d, "WikittyTreeNode.parent", FieldType.TYPE.WIKITTY);
                        int nb = counts.containsKey(id) ? (Integer)counts.get(id) : 0;
                        TreeNodeResult child = new TreeNodeResult((Serializable)((Object)id), nb);
                        allTreeNodeResult.put(id, child);
                        childParent.put(id, parentId);
                    }
                    for (Map.Entry e : allTreeNodeResult.entrySet()) {
                        id = (String)e.getKey();
                        parentId = (String)childParent.get(id);
                        if (!allTreeNodeResult.containsKey(parentId)) continue;
                        TreeNodeResult child = (TreeNodeResult)e.getValue();
                        TreeNodeResult parent = (TreeNodeResult)allTreeNodeResult.get(parentId);
                        if (parent == child) continue;
                        parent.add((MutableTreeNode)child);
                    }
                    result = (TreeNodeResult)allTreeNodeResult.get(wikittyId);
                } else {
                    throw new WikittyException(String.format("Wikitty '%s' do not handle extension %s", wikittyId, "WikittyTreeNode"));
                }
            }
            return result;
        }
        catch (SolrServerException eee) {
            throw new WikittyException("Error during find", (Throwable)eee);
        }
    }

    protected void addToIndexDocument(SolrInputDocument doc, FieldType.TYPE type, String fqfieldName, Object fieldValue, boolean collection) {
        if (fqfieldName.startsWith("#")) {
            doc.remove((Object)fqfieldName);
            doc.addField(fqfieldName, fieldValue);
        } else {
            String solrFqFieldName = SolrUtil.getSolrFieldName(fqfieldName, type);
            String solrAllFieldName = "#all." + WikittyUtil.getFieldNameFromFQFieldName((String)solrFqFieldName);
            String solrFulltextAllFieldName = "#ft.all." + WikittyUtil.getFieldNameFromFQFieldName((String)fqfieldName);
            String solrNullFieldFqFieldName = "#null_field-" + fqfieldName;
            String solrFqFieldNameSortable = solrFqFieldName + "_sortable";
            doc.remove((Object)solrFqFieldName);
            doc.remove((Object)solrNullFieldFqFieldName);
            doc.remove((Object)solrAllFieldName);
            doc.remove((Object)solrFulltextAllFieldName);
            doc.remove((Object)solrFqFieldNameSortable);
            String solrNullFieldFqFieldNameValue = "true";
            if (fieldValue != null) {
                doc.addField(solrFqFieldName, fieldValue);
                doc.addField(solrAllFieldName, fieldValue);
                doc.addField(solrFulltextAllFieldName, fieldValue);
                Object oneFieldValue = SolrUtil.getOneValue(fieldValue);
                doc.addField(solrFqFieldNameSortable, oneFieldValue);
                solrNullFieldFqFieldNameValue = "false";
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("index field '%s' with value '%s'", solrFqFieldName, StringUtils.abbreviate((String)String.valueOf(fieldValue), (int)50)));
                }
            }
            doc.addField(solrNullFieldFqFieldName, (Object)solrNullFieldFqFieldNameValue);
        }
    }

    protected void addToIndexDocument(SolrInputDocument doc, Wikitty w, String fqfieldName) {
        Object fieldValue;
        FieldType.TYPE type = null;
        boolean collection = false;
        if ("#id".equals(fqfieldName)) {
            fieldValue = w.getId();
        } else if ("#extensions".equals(fqfieldName)) {
            fieldValue = w.getExtensionNames();
        } else {
            FieldType fieldType = w.getFieldType(fqfieldName);
            type = fieldType.getType();
            collection = fieldType.isCollection();
            fieldValue = w.getFqField(fqfieldName);
        }
        this.addToIndexDocument(doc, type, fqfieldName, fieldValue, collection);
    }

    protected SolrInputDocument createIndexDocument(Wikitty w) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("create index wikitty for '%s'", w.getId()));
        }
        SolrInputDocument doc = new SolrInputDocument();
        this.addToIndexDocument(doc, w, "#id");
        this.addToIndexDocument(doc, w, "#extensions");
        for (String fqfieldName : w.getAllFieldNames()) {
            this.addToIndexDocument(doc, w, fqfieldName);
        }
        return doc;
    }
}

