/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.NaNFloatWriter;
import org.apache.solr.response.SolrQueryResponse;

class PythonWriter
extends NaNFloatWriter {
    protected String getNaN() {
        return "float('NaN')";
    }

    protected String getInf() {
        return "float('Inf')";
    }

    public PythonWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
    }

    public void writeNull(String name) throws IOException {
        this.writer.write("None");
    }

    public void writeBool(String name, boolean val) throws IOException {
        this.writer.write(val ? "True" : "False");
    }

    public void writeBool(String name, String val) throws IOException {
        this.writeBool(name, val.charAt(0) == 't');
    }

    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        if (!needsEscaping) {
            this.writer.write('\'');
            this.writer.write(val);
            this.writer.write('\'');
            return;
        }
        StringBuilder sb = new StringBuilder(val.length());
        boolean needUnicode = false;
        block6: for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            switch (ch) {
                case '\'': 
                case '\\': {
                    sb.append('\\');
                    sb.append(ch);
                    continue block6;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block6;
                }
                default: {
                    if (ch < ' ' || ch > '\u007f') {
                        PythonWriter.unicodeEscape(sb, ch);
                        needUnicode = true;
                        continue block6;
                    }
                    sb.append(ch);
                }
            }
        }
        if (needUnicode) {
            this.writer.write('u');
        }
        this.writer.write('\'');
        this.writer.append((CharSequence)sb);
        this.writer.write('\'');
    }
}

