/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.solr.analysis.BaseTokenizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathHierarchyTokenizerFactory
extends BaseTokenizerFactory {
    private char delimiter;
    private char replacement;

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        String v = args.get("delimiter");
        if (v != null) {
            if (v.length() != 1) {
                throw new IllegalArgumentException("delimiter should be a char. \"" + v + "\" is invalid");
            }
            this.delimiter = v.charAt(0);
        } else {
            this.delimiter = (char)47;
        }
        v = args.get("replace");
        if (v != null) {
            if (v.length() != 1) {
                throw new IllegalArgumentException("replace should be a char. \"" + v + "\" is invalid");
            }
            this.replacement = v.charAt(0);
        } else {
            this.replacement = this.delimiter;
        }
    }

    @Override
    public Tokenizer create(Reader input) {
        return new PathHierarchyTokenizer(input, this.delimiter, this.replacement);
    }
}

