/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.InvertedDocConsumer;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.InvertedDocConsumerPerThread;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermsHashConsumer;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.TermsHashPerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TermsHash
extends InvertedDocConsumer {
    final TermsHashConsumer consumer;
    final TermsHash nextTermsHash;
    final DocumentsWriter docWriter;
    boolean trackAllocations;

    public TermsHash(DocumentsWriter docWriter, boolean trackAllocations, TermsHashConsumer consumer, TermsHash nextTermsHash) {
        this.docWriter = docWriter;
        this.consumer = consumer;
        this.nextTermsHash = nextTermsHash;
        this.trackAllocations = trackAllocations;
    }

    @Override
    InvertedDocConsumerPerThread addThread(DocInverterPerThread docInverterPerThread) {
        return new TermsHashPerThread(docInverterPerThread, this, this.nextTermsHash, null);
    }

    TermsHashPerThread addThread(DocInverterPerThread docInverterPerThread, TermsHashPerThread primaryPerThread) {
        return new TermsHashPerThread(docInverterPerThread, this, this.nextTermsHash, primaryPerThread);
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        this.fieldInfos = fieldInfos;
        this.consumer.setFieldInfos(fieldInfos);
    }

    @Override
    public void abort() {
        this.consumer.abort();
        if (this.nextTermsHash != null) {
            this.nextTermsHash.abort();
        }
    }

    @Override
    synchronized void flush(Map<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>> threadsAndFields, SegmentWriteState state) throws IOException {
        HashMap<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> childThreadsAndFields = new HashMap<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>>();
        HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>> nextThreadsAndFields = this.nextTermsHash != null ? new HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>>() : null;
        for (Map.Entry<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>> entry : threadsAndFields.entrySet()) {
            TermsHashPerThread perThread = (TermsHashPerThread)entry.getKey();
            Collection<InvertedDocConsumerPerField> fields = entry.getValue();
            Iterator<InvertedDocConsumerPerField> fieldsIt = fields.iterator();
            HashSet<TermsHashConsumerPerField> childFields = new HashSet<TermsHashConsumerPerField>();
            HashSet<TermsHashPerField> nextChildFields = this.nextTermsHash != null ? new HashSet<TermsHashPerField>() : null;
            while (fieldsIt.hasNext()) {
                TermsHashPerField perField = (TermsHashPerField)fieldsIt.next();
                childFields.add(perField.consumer);
                if (this.nextTermsHash == null) continue;
                nextChildFields.add(perField.nextPerField);
            }
            childThreadsAndFields.put(perThread.consumer, childFields);
            if (this.nextTermsHash == null) continue;
            nextThreadsAndFields.put(perThread.nextPerThread, nextChildFields);
        }
        this.consumer.flush(childThreadsAndFields, state);
        if (this.nextTermsHash != null) {
            this.nextTermsHash.flush(nextThreadsAndFields, state);
        }
    }

    @Override
    public synchronized boolean freeRAM() {
        return false;
    }
}

