/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: SampleRowHistoric.java 1426 2011-12-19 09:35:29Z bleny $
 * $HeadURL: http://svn.forge.codelutin.com/svn/wao/tags/wao-3.4.1/wao-ui/src/main/java/fr/ifremer/wao/ui/pages/SampleRowHistoric.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.SampleRowLog;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.components.FeedBack;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

/**
 * SampleRowHistoric
 *
 * Created: 12 janv. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
@RequiresAuthentication
@Import(stylesheet = "context:css/sampling.css")
public class SampleRowHistoric {

    @Inject
    private Logger log;

    @SessionState
    private ConnectedUser user;

    @InjectComponent
    private Layout layout;

    @Inject
    private ServiceSampling serviceSampling;
    
    private String sampleRowCode;
    
    @Persist
    private SampleRow sampleRow;

    @Property
    private SampleRowLog sampleRowLog;

    private SampleRowLog newLog;

    @InjectComponent
    private FeedBack addCommentInfo;

    void onActivate(String id) {
        sampleRowCode = id;
    }

    String onPassivate() {
        return sampleRowCode;
    }

    void setupRender() throws WaoException {
        if (StringUtils.isEmpty(sampleRowCode)) {
            layout.addFatal("L'historique ne peut pas être affiché : " +
                    "Aucun code de ligne n'est spécifié dans l'url. ");
        } else {

            try {
                sampleRow = null;
                getSampleRow();
            } catch (WaoBusinessException eee) {
                layout.addFatal("L'historique ne peut pas être affiché : "
                        + eee.getMessage());
            }

            if (canAddComment()) {
                addCommentInfo.addInfo("L'ajout d'un commentaire enverra" +
                        " un email aux administrateurs du programme Obsmer");
            }
        }
    }

    public SampleRow getSampleRow() throws WaoBusinessException {
        if (sampleRow == null) {
            sampleRow = serviceSampling.getSampleRowByCode(user, sampleRowCode);
        }
        return sampleRow;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.FRENCH);
    }

    public String getContent() {
        String content = sampleRowLog.getLogText();
        if (content == null) {
            content = "Aucun changement enregistré.";
        } else {
            content = content.replaceAll("\\n", "<br />");
        }
        return content;
    }

    public String getLogStyle() {
        String styleClass = "head-";
        if (sampleRowLog.getFromAdmin()) {
            styleClass += "admin";
        } else {
            styleClass += "company";
        }
        return styleClass;
    }

    public SampleRowLog getNewLog() throws WaoBusinessException {
        if (newLog == null) {
            newLog = serviceSampling.getNewSampleRowLog(getSampleRow(), user);
        }
        return newLog;
    }

    public boolean canAddComment() {
        return user.getRole().equals(UserRole.COORDINATOR) &&
                !user.isReadOnly();
    }

    public void onSuccessFromAddComment() throws WaoException {
        if (canAddComment()) {
            try {
                serviceSampling.createSampleRowLog(newLog);
            } catch (WaoBusinessException eee) {
                layout.addInfo(eee.getMessage());
            }
        }
    }
        
}
