/*
 * Decompiled with CFR 0.152.
 */
package winstone.realm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import winstone.AuthenticationPrincipal;
import winstone.AuthenticationRealm;
import winstone.Logger;
import winstone.WinstoneException;
import winstone.WinstoneResourceBundle;

public class FileRealm
implements AuthenticationRealm {
    private static final WinstoneResourceBundle REALM_RESOURCES = new WinstoneResourceBundle("winstone.realm.LocalStrings");
    final String FILE_NAME_ARGUMENT = "fileRealm.configFile";
    final String DEFAULT_FILE_NAME = "users.xml";
    final String ELEM_USER = "user";
    final String ATT_USERNAME = "username";
    final String ATT_PASSWORD = "password";
    final String ATT_ROLELIST = "roles";
    private Map passwords = new Hashtable();
    private Map roles = new Hashtable();

    public FileRealm(Set rolesAllowed, Map args) {
        String realmFileName = args.get("fileRealm.configFile") == null ? "users.xml" : (String)args.get("fileRealm.configFile");
        File realmFile = new File(realmFileName);
        if (!realmFile.exists()) {
            throw new WinstoneException(REALM_RESOURCES.getString("FileRealm.FileNotFound", realmFile.getPath()));
        }
        try {
            FileInputStream inFile = new FileInputStream(realmFile);
            Document doc = this.parseStreamToXML(inFile);
            ((InputStream)inFile).close();
            Element rootElm = doc.getDocumentElement();
            for (int n = 0; n < rootElm.getChildNodes().getLength(); ++n) {
                Node child = rootElm.getChildNodes().item(n);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("user")) continue;
                String userName = null;
                String password = null;
                String roleList = null;
                for (int j = 0; j < child.getAttributes().getLength(); ++j) {
                    Node thisAtt = child.getAttributes().item(j);
                    if (thisAtt.getNodeName().equals("username")) {
                        userName = thisAtt.getNodeValue();
                        continue;
                    }
                    if (thisAtt.getNodeName().equals("password")) {
                        password = thisAtt.getNodeValue();
                        continue;
                    }
                    if (!thisAtt.getNodeName().equals("roles")) continue;
                    roleList = thisAtt.getNodeValue();
                }
                if (userName == null || password == null || roleList == null) {
                    Logger.log(Logger.FULL_DEBUG, REALM_RESOURCES, "FileRealm.SkippingUser", userName);
                    continue;
                }
                StringTokenizer st = new StringTokenizer(roleList, ",");
                ArrayList<String> rl = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String currentRole = st.nextToken();
                    if (!rolesAllowed.contains(currentRole)) continue;
                    rl.add(currentRole);
                }
                Object[] roleArray = rl.toArray();
                Arrays.sort(roleArray);
                this.passwords.put(userName, password);
                this.roles.put(userName, Arrays.asList(roleArray));
            }
            Logger.log(Logger.DEBUG, REALM_RESOURCES, "FileRealm.Initialised", "" + this.passwords.size());
        }
        catch (IOException err) {
            throw new WinstoneException(REALM_RESOURCES.getString("FileRealm.ErrorLoading"), err);
        }
    }

    private Document parseStreamToXML(InputStream in) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            factory.setIgnoringComments(true);
            factory.setCoalescing(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(in);
        }
        catch (Throwable errParser) {
            throw new WinstoneException(REALM_RESOURCES.getString("FileRealm.XMLParseError"), errParser);
        }
    }

    public AuthenticationPrincipal authenticateByUsernamePassword(String userName, String password) {
        if (userName == null || password == null) {
            return null;
        }
        String realPassword = (String)this.passwords.get(userName);
        if (realPassword == null) {
            return null;
        }
        if (!realPassword.equals(password)) {
            return null;
        }
        return new AuthenticationPrincipal(userName, password, (List)this.roles.get(userName));
    }

    public AuthenticationPrincipal retrieveUser(String userName) {
        return new AuthenticationPrincipal(userName, (String)this.passwords.get(userName), (List)this.roles.get(userName));
    }
}

