/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.service.ServiceCartography;
import fr.ifremer.wao.ui.data.KmlStreamResponse;
import org.apache.tapestry5.StreamResponse;

import java.io.IOException;

public class KmlLoaderStrategyContactsStatesMotifs implements KmlLoaderStrategy<ContactFilter>  {

    protected ServiceCartography serviceCartography;

    public KmlLoaderStrategyContactsStatesMotifs(ServiceCartography serviceCartography) {
        this.serviceCartography = serviceCartography;
    }

    @Override
    public StreamResponse getStreamResponse(ContactFilter filter) throws IOException {
        return new KmlStreamResponse(
            serviceCartography.exportContactMotifsStatisticsKml(filter)
        );
    }
}
