/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
/**
 * This class is used to hide news details depends on an anchor. This anchor
 * must be called 'details' and be surrounded by a paragraph block (<p>) in
 * the news content. The anchor will be transformed in a clickable link, then
 * the rest of the news will be hidden using NewsDetails object.
 */
NewsHider = Class.create({
    initialize: function() {
        this.allNews = $('so-news').select('div.news-content');
        this.anchorPattern = 'a[name="details"]';
    },
    /**
     * Method to call to hide all news that contains the anchor 'details'
     */
    hideAllNewsDetails: function() {         
        for (j = 0; j < this.allNews.length; j++) {
            this.hideNewsDetails(this.allNews[j]);
        }
    },
    /**
     * Hide a {news} if contains an anchor called 'details'. A NewsDetails object
     * will be instantiate to transform the anchor found and hide the rest of
     * the news in a hiddenBlock.
     */
    hideNewsDetails: function(news) {
        // Select all paragraphs in the news
        var paragraphs = news.select('p');
        //Tapestry.debug('nb paragraphs in news : ' + paragraphs.length);

        for (i = 0; i < paragraphs.length; i++) {
            var paragraph = paragraphs[i];

            // Check the firstDescendant in the paragraph, we take only anchor called 'details'
            if (paragraph.firstDescendant() && paragraph.firstDescendant().match(this.anchorPattern)) {
                var anchor = paragraph.firstDescendant();

                //Tapestry.debug('Find anchor !');

                // paragraphs to hide are the next siblings of current paragraph
                var paragraphsToHide = paragraph.nextSiblings();

                var details = new NewsDetails(anchor, paragraphsToHide);

                // append the hidden block to the news
                news.appendChild(details.hiddenBlock);
                break;
            }
        }
    }
});

/**
 * This class is used to transform an {anchor} in clickable link to display a
 * hidden block as news details. The {paragraphsToHide} will be wrapped into
 * a div hidden element. When user will click on the {anchor}, the hidden
 * block will be toggled to be displayed or not.
 */
NewsDetails = Class.create({
    initialize: function(anchor, paragraphsToHide) {

        //Tapestry.debug('create NewsDetails');

        // Update params of the anchor to be clickable
        anchor.update('Lire la suite...');
        anchor.addClassName('news-details-link');
        // Bind the click on the anchor with the toggle on hiddenBlock
        anchor.observe('click', this.toggleDetails.bind(this));

        // Create hidden block
        this.hiddenBlock = document.createElement('div');
        this.hiddenBlock.addClassName('hidden');

        for (i = 0; i < paragraphsToHide.length; i++) {
            this.hiddenBlock.appendChild(paragraphsToHide[i]);
        }
    },
    toggleDetails: function(event) {
        this.hiddenBlock.toggleClassName('hidden');
    }
});