/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.services.WaoManager;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ExceptionReporter;
import org.slf4j.Logger;

public class ExceptionReport
implements ExceptionReporter,
WaoPage {
    @InjectComponent
    private Layout layout;
    @Inject
    private Logger log;
    @Inject
    private Messages messages;
    @Inject
    private WaoManager manager;
    @Property
    private Throwable exception;

    public boolean canDisplay() {
        return true;
    }

    public void initialize() {
    }

    public void reportException(Throwable eee) {
        this.exception = this.getWaoException(eee);
        if (this.exception != null) {
            String[] errors = this.manager.getErrorMessages((WaoException)this.exception, this.messages, this.log);
            this.layout.addError(errors);
        } else if (this.manager.isDevEnvironment()) {
            this.log.error("Unexpected exception", eee);
            this.layout.addError(new String[]{"Erreur : " + eee.getClass().getSimpleName() + " : " + eee.getMessage()});
        } else {
            this.layout.addError(new String[]{"Une erreur inattendue vient de se produire. Veuillez recharger la page. Contactez un administrateur si ce message continue de s'afficher."});
        }
    }

    protected Throwable getWaoException(Throwable eee) {
        if (eee == null) {
            return eee;
        }
        if (eee instanceof WaoException) {
            return eee;
        }
        return this.getWaoException(eee.getCause());
    }
}

