/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.Profession;
import fr.ifremer.wao.entity.SampleRow;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class BusinessUtils {
    public static String getTooltipSampleRow(SampleRow row) {
        String result = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
        Profession profession = row.getProfession();
        result = result + "<strong>M\u00e9tier : </strong>" + profession.getCodeDCF5();
        if (!StringUtils.isEmpty((String)profession.getMeshSize())) {
            result = result + " " + profession.getMeshSize();
        }
        if (!StringUtils.isEmpty((String)profession.getSize())) {
            result = result + " " + profession.getSize();
        }
        if (!StringUtils.isEmpty((String)profession.getOther())) {
            result = result + " " + profession.getOther();
        }
        result = result + " - " + profession.getLibelle();
        if (!StringUtils.isEmpty((String)profession.getSpecies())) {
            result = result + "<br /><strong>Esp\u00e8ces cibles : </strong>" + profession.getSpecies();
        }
        result = result + "<br /><strong>Programme : </strong>" + row.getProgramName();
        result = result + "<br /><strong>P\u00e9riode : </strong> du " + dateFormat.format(row.getPeriodBegin()) + " au " + dateFormat.format(row.getPeriodEnd());
        for (FishingZone zone : row.getFishingZone()) {
            result = result + "<br /><strong>Zone de p\u00eache : </strong>" + zone.getCode();
        }
        return result;
    }

    public static String getTooltipBoat(Boat boat) {
        String result = "";
        result = result + "<strong>" + boat.getImmatriculation() + "</strong>";
        result = result + "<br /><strong>Quartier : </strong>" + boat.getDistrictCode();
        result = result + "<br /><strong>Longueur : </strong>" + boat.getBoatLength() + " m";
        result = result + "<br /><strong>Ann\u00e9e de construction : </strong>" + boat.getBuildYear();
        return result;
    }

    public static String getDataSamplingTitle(SamplingFilter filter) {
        String result = "Donn\u00e9es des mar\u00e9es";
        boolean filtered = false;
        if (filter.getCompany() != null) {
            result = result + " :\nSoci\u00e9t\u00e9 " + filter.getCompany().getName();
            filtered = true;
        }
        if (StringUtils.isNotEmpty((String)filter.getProgramName())) {
            result = result + (!filtered ? " : " : ", ");
            result = result + "\nProgramme " + filter.getProgramName();
            filtered = true;
        }
        if (filter.getSampleRow() != null) {
            Profession profession = filter.getSampleRow().getProfession();
            result = result + (!filtered ? " : " : ", ");
            result = result + "\nM\u00e9tier " + profession.getCode();
            result = result + (StringUtils.isNotEmpty((String)profession.getLibelle()) ? " - " + profession.getLibelle() : "");
            result = result + (StringUtils.isNotEmpty((String)profession.getSpecies()) ? "\nEsp\u00e8ces (" + profession.getSpecies() + ")" : "");
            result = result + "\nZones de p\u00eache (";
            for (FishingZone zone : filter.getSampleRow().getFishingZone()) {
                result = result + zone.getDistrictCode() + " ";
            }
            result = result + ")";
            filtered = true;
        } else {
            if (filter.getFacadeName() != null) {
                result = result + (!filtered ? " : " : ", ");
                result = result + "\nFa\u00e7ade " + filter.getFacadeName();
                filtered = true;
            }
            if (filter.getSectorName() != null) {
                result = result + (!filtered ? " : " : ", ");
                result = result + "\nZone " + filter.getSectorName();
            }
        }
        return result;
    }

    public static String getContactStyle(Contact contact, boolean admin) {
        String result = "";
        boolean accepted = BooleanUtils.isTrue((Boolean)contact.getValidationProgram()) || !admin && BooleanUtils.isTrue((Boolean)contact.getValidationCompany());
        ContactState state = ContactState.createContactStateEnum((String)contact.getState());
        result = BooleanUtils.isFalse((Boolean)contact.getValidationProgram()) || !admin && BooleanUtils.isFalse((Boolean)contact.getValidationCompany()) ? "refused" : (accepted && state.equals((Object)ContactState.BOARDING_DONE) ? "accepted" : (accepted && state.isUnfinishedState() ? "unfinished" : (state.isFinalState() ? "even" : "odd")));
        return result;
    }
}

