/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.SampleRowLog;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.base.WaoPage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/sampling.css"})
public class SampleRowHistoric
implements WaoPage {
    @Inject
    private Logger log;
    @Inject
    private ServiceSampling serviceSampling;
    private String sampleRowId;
    @Persist
    private SampleRow sampleRow;
    @Property
    private SampleRowLog sampleRowLog;

    public boolean isOnlyForAdmin() {
        return true;
    }

    void onActivate(String id) {
        this.sampleRowId = id;
    }

    String onPassivate() {
        return this.sampleRowId;
    }

    void setupRender() throws WaoException {
        this.sampleRow = null;
        this.getSampleRow();
    }

    public SampleRow getSampleRow() throws WaoException {
        if (this.sampleRow == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSampleRow]");
            }
            this.sampleRow = this.serviceSampling.getSampleRow(this.sampleRowId);
        }
        return this.sampleRow;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.FRENCH);
    }

    public String getContent() {
        String content = this.sampleRowLog.getLogText();
        content = content == null ? "Aucun changement enregistr\u00e9." : content.replaceAll("\\n", "<br />");
        return content;
    }
}

