/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ResourceStreamProvider;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.scriptio.ScriptReaderBase;

class ScriptReaderBinary
extends ScriptReaderBase {
    private RowInputBinary rowIn = new RowInputBinary();
    protected DataInputStream dataStreamIn;

    ScriptReaderBinary(Database database, String string) throws HsqlException, IOException {
        super(database, string);
    }

    protected void openFile() throws IOException {
        InputStream inputStream = this.db.isFilesInJar() ? ResourceStreamProvider.getResourceAsStream(this.fileName) : this.db.getFileAccess().openInputStreamElement(this.fileName);
        this.dataStreamIn = new DataInputStream(new BufferedInputStream(inputStream, 8192));
    }

    protected void readDDL(Session session) throws IOException, HsqlException {
        Result result = Result.read(this.rowIn, this.dataStreamIn);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            String string = (String)objectArray[0];
            Result result2 = session.sqlExecuteDirectNoPreChecks(string);
            if (!result2.isError()) continue;
            this.db.logger.appLog.logContext(1, result2.getMainString());
            throw Trace.error(result2);
        }
    }

    protected void readExistingData(Session session) throws IOException, HsqlException {
        String string;
        while ((string = this.readTableInit()) != null) {
            String string2 = session.getSchemaName(this.currentSchema);
            Table table = this.db.schemaManager.getUserTable(session, string, string2);
            int n = 0;
            n = 0;
            while (this.readRow(table)) {
                ++n;
            }
            int n2 = this.readTableTerm();
            if (n == n2) continue;
            throw Trace.error(78, 96, new Object[]{string, new Integer(n), new Integer(n2)});
        }
    }

    protected boolean readRow(Table table) throws IOException, HsqlException {
        boolean bl = this.readRow(this.rowIn, 0);
        if (!bl) {
            return false;
        }
        Object[] objectArray = this.rowIn.readData(table.getColumnTypes());
        table.insertFromScript(objectArray);
        return true;
    }

    protected int readTableTerm() throws IOException, HsqlException {
        return this.dataStreamIn.readInt();
    }

    protected String readTableInit() throws IOException, HsqlException {
        boolean bl = this.readRow(this.rowIn, 0);
        if (!bl) {
            return null;
        }
        String string = this.rowIn.readString();
        int n = this.rowIn.readIntData();
        this.currentSchema = n == 1 ? this.rowIn.readString() : null;
        if (n != 0 && n != 1) {
            throw Trace.error(78, 97);
        }
        return string;
    }

    boolean readRow(RowInputBase rowInputBase, int n) throws IOException {
        try {
            int n2 = this.dataStreamIn.readInt();
            int n3 = 4;
            if (n2 == 0) {
                return false;
            }
            rowInputBase.resetRow(n, n2);
            this.dataStreamIn.readFully(rowInputBase.getBuffer(), n3, n2 - n3);
            return true;
        }
        catch (EOFException eOFException) {
            return false;
        }
    }

    public boolean readLoggedStatement(Session session) throws IOException {
        return false;
    }

    public void close() {
        try {
            this.dataStreamIn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

