/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.data.AbstractSpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.AbstractSpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceServiceSupport;
import fr.ifremer.tutti.persistence.service.util.BatchPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.tree.SpeciesBatchTreeHelper;
import fr.ifremer.tutti.persistence.service.util.tree.SpeciesBatchTreeHelperSupport;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service(value="speciesBatchPersistenceService")
public class SpeciesBatchPersistenceServiceImpl
extends SpeciesBatchPersistenceServiceSupport
implements SpeciesBatchPersistenceService {
    private static final Log log = LogFactory.getLog(SpeciesBatchPersistenceServiceImpl.class);
    @Resource(name="speciesBatchTreeHelper")
    protected SpeciesBatchTreeHelper batchTreeHelper;

    public SpeciesBatchPersistenceServiceImpl() {
        super("Species", AbstractSpeciesBatchs::newSpeciesBatch, AbstractSpeciesBatchFrequencys::newSpeciesBatchFrequency);
    }

    @Override
    protected SpeciesBatchTreeHelperSupport getBatchTreeHelper() {
        return this.batchTreeHelper;
    }

    @Override
    protected void validate(BatchPersistenceHelper batchHelper, SampleCategoryModel sampleCategoryModel, BatchContainer<SpeciesBatch> result) {
        batchHelper.validateSpecies(sampleCategoryModel, result);
    }

    @Override
    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(Integer fishingOperationId, boolean validateTree) throws InvalidBatchModelException {
        return this.getRootSpeciesBatch0(fishingOperationId, validateTree);
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, Integer parentBatchId, boolean computeRankOrder) {
        return this.createSpeciesBatch0(bean, parentBatchId, computeRankOrder);
    }

    @Override
    public Collection<SpeciesBatch> createSpeciesBatches(Integer fishingOperationId, Collection<SpeciesBatch> beans) {
        return this.createSpeciesBatches0(fishingOperationId, beans);
    }

    protected SpeciesBatch createSpeciesBatch(SpeciesBatch bean, Integer parentBatchId, CatchBatch catchBatch, boolean computeRankOrder) {
        return this.createSpeciesBatch0(bean, parentBatchId, catchBatch, computeRankOrder);
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        return this.saveSpeciesBatch0(bean);
    }

    @Override
    public void deleteSpeciesBatch(Integer id) {
        this.deleteSpeciesBatch0(id);
    }

    @Override
    public void deleteSpeciesSubBatch(Integer id) {
        this.deleteSpeciesSubBatch0(id);
    }

    @Override
    public void changeSpeciesBatchSpecies(Integer id, Species species) {
        this.changeSpeciesBatchSpecies0(id, species);
    }

    @Override
    public List<SpeciesBatch> getAllSpeciesBatchToConfirm(Integer fishingOperationId) throws InvalidBatchModelException {
        return this.getAllSpeciesBatchToConfirm0(fishingOperationId);
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(Integer speciesBatchId) {
        return this.getAllSpeciesBatchFrequency0(speciesBatchId);
    }

    @Override
    public Multimap<Species, SpeciesBatchFrequency> getAllSpeciesBatchFrequencyForBatch(BatchContainer<SpeciesBatch> batchContainer) {
        return this.getAllSpeciesBatchFrequencyForBatch0(batchContainer);
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(Integer speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.saveSpeciesBatchFrequency0(speciesBatchId, frequencies);
    }
}

