/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.sampling;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.sampling.CacheExtractedKey;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

class CruiseSamplingInternalCache
implements Closeable {
    private static final String KEY_SEPARATOR = "#";
    private final Map<String, SamplingData> data = new TreeMap<String, SamplingData>();
    private static final String TO_STRING_VERBOSE_FORMAT = "\n%1$-40s \u2192 %2$s";

    CruiseSamplingInternalCache() {
    }

    public static String createSamplingKey(Species species, CaracteristicQualitativeValue gender, Boolean maturity, int lengthStep) {
        Objects.requireNonNull(species);
        return species.getReferenceTaxonId() + KEY_SEPARATOR + (gender == null ? "" : gender.getId()) + KEY_SEPARATOR + (maturity == null ? "" : maturity.toString()) + KEY_SEPARATOR + lengthStep;
    }

    public static String addPrefixKey(Serializable prefix, String key) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(key);
        return prefix + KEY_SEPARATOR + key;
    }

    public SamplingData getSamplingData(String samplingKey) {
        Objects.requireNonNull(samplingKey);
        return this.data.get(samplingKey);
    }

    public SamplingData getOrCreateSamplingData(String samplingKey) {
        Objects.requireNonNull(samplingKey);
        return this.data.computeIfAbsent(samplingKey, s -> new SamplingData());
    }

    @Override
    public void close() {
        this.data.clear();
    }

    public int size() {
        return this.data.size();
    }

    public List<CacheExtractedKey> getSamplingNumbers(Map<String, Species> speciesById, Map<Integer, CaracteristicQualitativeValue> sexQualitativeValues) {
        LinkedList<CacheExtractedKey> result = new LinkedList<CacheExtractedKey>();
        for (Map.Entry<String, SamplingData> entry : this.data.entrySet()) {
            SamplingData samplingData = entry.getValue();
            if (!samplingData.withSampling()) continue;
            String[] keyTokens = entry.getKey().split(KEY_SEPARATOR);
            CacheExtractedKey key = new CacheExtractedKey();
            int i = 0;
            String nextToken = keyTokens[i++];
            Species species = speciesById.get(nextToken);
            key.setSpecies(species);
            nextToken = keyTokens[i++];
            if (!StringUtils.isEmpty((CharSequence)nextToken)) {
                Integer sexId = Integer.parseInt(nextToken);
                CaracteristicQualitativeValue sexQualitativeValue = sexQualitativeValues.get(sexId);
                key.setSex(sexQualitativeValue);
            }
            if (!StringUtils.isEmpty((CharSequence)(nextToken = keyTokens[i++]))) {
                Boolean maturity = Boolean.parseBoolean(nextToken);
                key.setMaturity(maturity);
            }
            if (!StringUtils.isEmpty((CharSequence)(nextToken = keyTokens[i]))) {
                int lengthStep = Integer.parseInt(nextToken);
                key.setLengthStep(lengthStep);
            }
            key.setSamplingNb(samplingData.getSamplingCount());
            result.add(key);
        }
        return result;
    }

    public SamplingData addOneIndividualObservation(String key) {
        SamplingData samplingData = this.getOrCreateSamplingData(key);
        samplingData.individualObservationCount++;
        return samplingData;
    }

    public SamplingData removeOneIndividualObservation(String key) {
        SamplingData samplingData = this.getSamplingData(key);
        Objects.requireNonNull(samplingData, "[" + key + "] You cannot decrement a individual observation if the sampling data does not exist");
        Preconditions.checkState((boolean)samplingData.withIndividualObservation(), (Object)("[" + key + "] You cannot decrement the observation count if there is no observation"));
        samplingData.individualObservationCount--;
        return samplingData;
    }

    public SamplingData addOneSampling(String key) {
        SamplingData samplingData = this.getOrCreateSamplingData(key);
        samplingData.samplingCount++;
        return samplingData;
    }

    public SamplingData removeOneSampling(String key) {
        SamplingData samplingData = this.getSamplingData(key);
        Objects.requireNonNull(samplingData, "[" + key + "] You cannot decrement a sampling count if the sampling data does not exist");
        Preconditions.checkState((boolean)samplingData.withSampling(), (Object)("[" + key + "] You cannot decrement a sampling count if there is no sampling"));
        samplingData.samplingCount--;
        return samplingData;
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public void remove(String key, int individualObservationCountToRemove, int samplingCountToRemove) {
        SamplingData samplingData = this.getSamplingData(key);
        Objects.requireNonNull(samplingData, "[" + key + "] not found.");
        int individualObservationCount = samplingData.getIndividualObservationCount();
        Preconditions.checkState((individualObservationCount >= individualObservationCountToRemove ? 1 : 0) != 0, (Object)("[" + key + "] You cannot decrement " + individualObservationCountToRemove + " individual observation(s), you just have " + individualObservationCount));
        SamplingData samplingData2 = samplingData;
        samplingData2.individualObservationCount = samplingData2.individualObservationCount - individualObservationCountToRemove;
        int samplingCount = samplingData.getSamplingCount();
        Preconditions.checkState((samplingCount >= samplingCountToRemove ? 1 : 0) != 0, (Object)("[" + key + "] You cannot decrement " + samplingCountToRemove + " sampling(s), you just have " + samplingCount));
        SamplingData samplingData3 = samplingData;
        samplingData3.samplingCount = samplingData3.samplingCount - samplingCountToRemove;
    }

    public void cleanEmptyEntries() {
        Iterator<Map.Entry<String, SamplingData>> iterator = this.data.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SamplingData> entry = iterator.next();
            SamplingData samplingData = entry.getValue();
            if (samplingData.withSampling() || samplingData.withIndividualObservation()) continue;
            iterator.remove();
        }
    }

    public String toStringVerbose() {
        StringBuilder stringBuilder = new StringBuilder(this.size() + " entries.");
        this.data.entrySet().forEach(entry -> stringBuilder.append(String.format(TO_STRING_VERBOSE_FORMAT, entry.getKey(), entry.getValue())));
        return stringBuilder.toString();
    }

    class SamplingData {
        private int individualObservationCount;
        private int samplingCount;

        SamplingData() {
        }

        public int getIndividualObservationCount() {
            return this.individualObservationCount;
        }

        public boolean withSampling() {
            return this.samplingCount > 0;
        }

        public boolean withIndividualObservation() {
            return this.individualObservationCount > 0;
        }

        public int getSamplingCount() {
            return this.samplingCount;
        }

        public String toString() {
            return MoreObjects.toStringHelper(SamplingData.class).add("individualObservationCount", this.individualObservationCount).add("samplingCount", this.samplingCount).toString();
        }
    }
}

