/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.csv.CaracteristicParserFormatter;
import fr.ifremer.tutti.service.csv.CaracteristicValueParserFormatter;
import fr.ifremer.tutti.service.csv.CommentParserFormatter;
import fr.ifremer.tutti.service.csv.CountryFormatter;
import fr.ifremer.tutti.service.csv.EnumByNameParserFormatter;
import fr.ifremer.tutti.service.csv.FishingOperationLocationParserFormatter;
import fr.ifremer.tutti.service.csv.FishingOperationStrataParserFormatter;
import fr.ifremer.tutti.service.csv.FishingOperationSubStrataParserFormatter;
import fr.ifremer.tutti.service.csv.GearListParserFormatter;
import fr.ifremer.tutti.service.csv.GearParserFormatter;
import fr.ifremer.tutti.service.csv.HarbourParserFormatter;
import fr.ifremer.tutti.service.csv.IntegerListParserFormatter;
import fr.ifremer.tutti.service.csv.PersonListParserFormatter;
import fr.ifremer.tutti.service.csv.PersonParserFormatter;
import fr.ifremer.tutti.service.csv.ProgramParserFormatter;
import fr.ifremer.tutti.service.csv.ProgramZoneFormatter;
import fr.ifremer.tutti.service.csv.SpeciesParserFormatter;
import fr.ifremer.tutti.service.csv.VesselListParserFormatter;
import fr.ifremer.tutti.service.csv.VesselParserFormatter;
import fr.ifremer.tutti.type.WeightUnit;
import java.io.Serializable;
import java.util.List;
import org.nuiton.csv.Common;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParserFormatter;
import org.nuiton.i18n.I18n;

public class TuttiCsvUtil
extends Common {
    public static final ValueParserFormatter<Float> WEIGHT_NULL_TO_9 = new Common.FloatParserFormatter(Float.valueOf(-9.0f), true){

        public String format(Float value) {
            if (value == null) {
                value = (Float)this.defaultValue;
            }
            return WeightUnit.KG.renderWeight(value);
        }

        protected Float parseNoneEmptyValue(String value) {
            Float aFloat = super.parseNoneEmptyValue(value);
            if (((Float)this.defaultValue).equals(aFloat)) {
                aFloat = null;
            }
            return aFloat;
        }
    };
    public static final ValueParserFormatter<Integer> INTEGER_NULL_TO_9 = new Common.IntegerParserFormatter(-9, true){

        public String format(Integer value) {
            if (value == null) {
                value = (Integer)this.defaultValue;
            }
            return super.format(value);
        }

        protected Integer parseNoneEmptyValue(String value) {
            Integer aFloat = super.parseNoneEmptyValue(value);
            if (((Integer)this.defaultValue).equals(aFloat)) {
                aFloat = null;
            }
            return aFloat;
        }
    };
    public static final ValueFormatter<Species> SPECIES_SURVEY_CODE_FORMATTER = s -> {
        Preconditions.checkNotNull((Object)s, (Object)I18n.t((String)"tutti.service.error.species.null", (Object[])new Object[0]));
        String surveyCode = s.getSurveyCode();
        return surveyCode == null ? "" : surveyCode;
    };
    public static final ValueFormatter<Species> SPECIES_REF_TAX_CODE_FORMATTER = s -> {
        Preconditions.checkNotNull((Object)s, (Object)I18n.t((String)"tutti.service.error.species.null", (Object[])new Object[0]));
        String surveyCode = s.getRefTaxCode();
        return surveyCode == null ? "" : surveyCode;
    };
    public static ValueParserFormatter<Float> WEIGHT_PARSER_FORMATTER = new Common.FloatParserFormatter(null, true){

        public String format(Float value) {
            if (value != null) {
                value = WeightUnit.KG.round(value);
            }
            return super.format(value);
        }

        protected Float parseNoneEmptyValue(String value) {
            Float aFloat = super.parseNoneEmptyValue(value);
            return WeightUnit.KG.round(aFloat);
        }
    };
    public static final CommentParserFormatter COMMENT_PARSER_FORMATTER = new CommentParserFormatter();
    public static final ValueFormatter<Caracteristic> CARACTERISTIC_FORMATTER = CaracteristicParserFormatter.newFormatter();
    public static final ValueFormatter<Caracteristic> CARACTERISTIC_TECHNICAL_FORMATTER = CaracteristicParserFormatter.newTechnicalFormatter();
    public static final ValueFormatter<Serializable> CARACTERISTIC_VALUE_FORMATTER = CaracteristicValueParserFormatter.newFormatter();
    public static ValueFormatter<Serializable> CARACTERISTIC_VALUE_TECHNICAL_FORMATTER = CaracteristicValueParserFormatter.newTechnicalFormatter();
    public static final ValueFormatter<Program> PROGRAM_FORMATTER = ProgramParserFormatter.newFormatter();
    public static final ValueFormatter<Program> PROGRAM_TECHNICAL_FORMATTER = ProgramParserFormatter.newTechnicalFormatter();
    public static final ValueFormatter<Gear> GEAR_FORMATTER = GearParserFormatter.newFormatter();
    public static final ValueFormatter<Gear> GEAR_TECHNICAL_FORMATTER = GearParserFormatter.newTechnicalFormatter();
    public static final ValueFormatter<List<Gear>> GEAR_LIST_TECHNICAL_FORMATTER = GearListParserFormatter.newFormatter(GearParserFormatter.newTechnicalFormatter());
    public static final ValueFormatter<TuttiLocation> COUNTRY_FORMATTER = new CountryFormatter();
    public static final ValueFormatter<TuttiLocation> PROGRAM_ZONE_FORMATTER = new ProgramZoneFormatter();
    public static final ValueFormatter<TuttiLocation> HARBOUR_FORMATTER = HarbourParserFormatter.newFormatter();
    public static final ValueFormatter<TuttiLocation> HARBOUR_TECHNICAL_FORMATTER = HarbourParserFormatter.newTechnicalFormatter();
    public static final ValueFormatter<TuttiLocation> FISHING_OPERATION_STRATA_FORMATTER = FishingOperationStrataParserFormatter.newFormatter();
    public static final ValueFormatter<TuttiLocation> FISHING_OPERATION_STRATA_TECHNICAL_FORMATTER = FishingOperationStrataParserFormatter.newTechnicalFormatter();
    public static final ValueFormatter<TuttiLocation> FISHING_OPERATION_SUB_STRATA_FORMATTER = FishingOperationSubStrataParserFormatter.newFormatter();
    public static final ValueFormatter<TuttiLocation> FISHING_OPERATION_SUB_STRATA_TECHNICAL_FORMATTER = FishingOperationSubStrataParserFormatter.newTechnicalFormatter();
    public static final ValueFormatter<TuttiLocation> FISHING_OPERATION_LOCATION_FORMATTER = FishingOperationLocationParserFormatter.newFormatter();
    public static final ValueFormatter<TuttiLocation> FISHING_OPERATION_LOCATION_TECHNICAL_FORMATTER = FishingOperationLocationParserFormatter.newTechnicalFormatter();
    public static final ValueFormatter<Vessel> VESSEL_FORMATTER = VesselParserFormatter.newFormatter();
    public static final ValueFormatter<Vessel> VESSEL_TECHNICAL_FORMATTER = VesselParserFormatter.newTechnicalFormatter();
    public static final ValueFormatter<Species> SPECIES_FORMATTER = SpeciesParserFormatter.newFormatter();
    public static final ValueFormatter<Species> SPECIES_TECHNICAL_FORMATTER = SpeciesParserFormatter.newTechnicalFormatter();
    public static final ValueFormatter<List<Person>> PERSON_LIST_FORMATTER = PersonListParserFormatter.newFormatter(PersonParserFormatter.newFormatter());
    public static final ValueFormatter<List<Person>> PERSON_LIST_TECHNICAL_FORMATTER = PersonListParserFormatter.newFormatter(PersonParserFormatter.newTechnicalFormatter());
    public static final ValueFormatter<List<Vessel>> VESSEL_LIST_FORMATTER = VesselListParserFormatter.newFormatter(VesselParserFormatter.newFormatter());
    public static final ValueFormatter<List<Vessel>> VESSEL_LIST_TECHNICAL_FORMATTER = VesselListParserFormatter.newFormatter(VesselParserFormatter.newTechnicalFormatter());
    public static final ValueParserFormatter<List<Integer>> INTEGER_LIST_PARSER_FORMATTER = new IntegerListParserFormatter();

    public static <E extends Enum<E>> ValueParserFormatter<E> newEnumByNameParserFormatter(Class<E> enumType, boolean mandatory) {
        return new EnumByNameParserFormatter<E>(enumType, mandatory);
    }

    protected TuttiCsvUtil() {
    }
}

