/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat.actions;

import com.google.common.base.Joiner;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportService;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatExportUI;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatExportUIHandler;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatExportUIModel;
import fr.ifremer.tutti.ui.swing.content.genericformat.actions.GenericFormatImportAction;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class GenericFormatExportAction
extends LongActionSupport<GenericFormatExportUIModel, GenericFormatExportUI, GenericFormatExportUIHandler> {
    private static final Log log = LogFactory.getLog(GenericFormatImportAction.class);
    private GenericFormatExportResult exportResult;
    private File exportFile;

    public GenericFormatExportAction(GenericFormatExportUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            doAction = ((GenericFormatExportUIModel)this.getModel()).isCanExport();
        }
        if (doAction) {
            Program program = ((GenericFormatExportUIModel)this.getModel()).getProgram();
            this.exportFile = this.saveFileWithStartDirectory(this.getConfig().getExportBackupDirectory(), false, "exportProgram-" + program.getName(), "zip", I18n.t((String)"tutti.genericFormat.title.choose.exportFile", (Object[])new Object[0]), I18n.t((String)"tutti.genericFormat.action.chooseExportFile", (Object[])new Object[0]), new String[]{"^.+\\.zip$", I18n.t((String)"tutti.common.file.genericFormat", (Object[])new Object[0])});
            doAction = this.exportFile != null;
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        GenericFormatExportConfiguration configuration = ((GenericFormatExportUIModel)this.getModel()).toExportConfiguration();
        configuration.setExportFile(this.exportFile);
        GenericFormatExportService service = this.getContext().getGenericFormatExportService();
        int nbSteps = service.getExportNbSteps(configuration);
        if (log.isInfoEnabled()) {
            log.info((Object)("Export nb steps: " + nbSteps));
        }
        this.createProgressionModelIfRequired(nbSteps);
        Program program = ((GenericFormatExportUIModel)this.getModel()).getProgram();
        if (log.isInfoEnabled()) {
            log.info((Object)("Do generic format export for program: " + program.getName() + " to file: " + this.exportFile));
        }
        this.exportResult = service.export(configuration, this.getProgressionModel());
        this.sendMessage(I18n.t((String)"tutti.genericFormat.export.action.success", (Object[])new Object[]{this.exportFile}));
        if (!this.exportResult.isSuccess()) {
            List errorsByCruise = this.exportResult.getErrorsByCruise();
            String errorMessage = I18n.t((String)"tutti.exportCruise.action.exportErrors", (Object[])new Object[]{program.getName(), Joiner.on((char)'\n').join((Iterable)errorsByCruise)});
            throw new ApplicationBusinessException(errorMessage);
        }
    }

    public void releaseAction() {
        this.exportFile = null;
        this.exportResult = null;
        super.releaseAction();
    }
}

