/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.caracteristics.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorRowModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorTableModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUIModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CaracteristicEditorRemoveRowAction
extends SimpleActionSupport<CaracteristicMapEditorUI> {
    private static final Log log = LogFactory.getLog(CaracteristicEditorRemoveRowAction.class);
    private static final long serialVersionUID = 1L;

    public CaracteristicEditorRemoveRowAction(CaracteristicMapEditorUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(CaracteristicMapEditorUI ui) {
        CaracteristicMapEditorUIModel model;
        CaracteristicMap caracteristicMap;
        int rowIndex = ui.getCaracteristicMapEditorTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove caracteristic if no caracteristic selected");
        CaracteristicMapEditorTableModel tableModel = ui.getHandler().getTableModel();
        CaracteristicMapEditorRowModel row = (CaracteristicMapEditorRowModel)((Object)tableModel.getEntry(rowIndex));
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove caracteristic row: " + (Object)((Object)row)));
        }
        if ((caracteristicMap = (model = ui.getModel()).getCaracteristicMap()) != null) {
            caracteristicMap.remove((Object)row.getKey());
        }
        BeanFilterableComboBox<Caracteristic> keyCombo = ui.getNewRowKey();
        keyCombo.addItem((Object)row.getKey());
        keyCombo.reset();
        model.getRows().remove(rowIndex);
        tableModel.fireTableRowsDeleted(rowIndex, rowIndex);
        model.removeRowInError(row);
    }
}

