/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.validation.actions;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.BatchSavedEvent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.BatchSavedListener;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;

public class EditFishingOperationInValidationUIAction
extends LongActionSupport<ValidateCruiseUIModel, ValidateCruiseUI, ValidateCruiseUIHandler> {
    private final ValidateCruiseOperationsService validationService;
    protected FishingOperation fishingOperation;
    protected final PropertyChangeListener editFishingOperationModelListener = new PropertyChangeListener(){
        protected final List<String> propertiesToIgnore = Lists.newArrayList((Object[])new String[]{"valid", "persisted"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditFishingOperationUIModel model = (EditFishingOperationUIModel)evt.getSource();
            if (!model.isLoadingData() && model.getFishingOperation() != null) {
                if ("modify".equals(evt.getPropertyName())) {
                    if (!model.isModify()) {
                        Cruise cruise = EditFishingOperationInValidationUIAction.this.getDataContext().reloadCruise();
                        ((ValidateCruiseUIModel)EditFishingOperationInValidationUIAction.this.getModel()).setCruise(cruise);
                    }
                } else if (!this.propertiesToIgnore.contains(evt.getPropertyName())) {
                    model.convertGearShootingCoordinatesToDD();
                    FishingOperation operation = (FishingOperation)model.toBean();
                    NuitonValidatorResult validationResult = EditFishingOperationInValidationUIAction.this.validationService.validateCruiseOperation(operation);
                    ValidateCruiseUIModel uiModel = (ValidateCruiseUIModel)EditFishingOperationInValidationUIAction.this.getModel();
                    uiModel.addValidatorResult(uiModel.getSelectedFishingOperation(), validationResult);
                    ((ValidateCruiseUIHandler)EditFishingOperationInValidationUIAction.this.getHandler()).updateCurrentOperationNode(validationResult);
                }
            }
        }
    };
    protected final PropertyChangeListener editCatchesModelListener = new PropertyChangeListener(){
        protected final List<String> propertiesToIgnore = Lists.newArrayList((Object[])new String[]{"valid", "catchTotalComputedWeight", "catchTotalSortedComputedWeight", "catchTotalUnsortedComputedWeight", "catchTotalRejectedComputedWeight", "speciesTotalComputedWeight", "speciesTotalSortedComputedWeight", "speciesTotalUnsortedComputedWeight", "speciesTotalSampleSortedComputedWeight", "speciesTotalInertComputedWeight", "speciesTotalLivingNotItemizedComputedWeight", "benthosTotalComputedWeight", "benthosTotalSortedComputedWeight", "benthosTotalUnsortedComputedWeight", "benthosTotalSampleSortedComputedWeight", "benthosTotalInertComputedWeight", "benthosTotalLivingNotItemizedComputedWeight"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditCatchesUIModel model = (EditCatchesUIModel)evt.getSource();
            if (!model.isLoadingData() && model.getFishingOperation() != null) {
                if ("modify".equals(evt.getPropertyName())) {
                    if (!model.isModify()) {
                        Cruise cruise = EditFishingOperationInValidationUIAction.this.getDataContext().reloadCruise();
                        ((ValidateCruiseUIModel)EditFishingOperationInValidationUIAction.this.getModel()).setCruise(cruise);
                    }
                } else if (!this.propertiesToIgnore.contains(evt.getPropertyName())) {
                    CatchBatch catchBatch = (CatchBatch)model.toBean();
                    NuitonValidatorResult validationResult = EditFishingOperationInValidationUIAction.this.validationService.validateCruiseOperation(catchBatch);
                    ValidateCruiseUIModel uiModel = (ValidateCruiseUIModel)EditFishingOperationInValidationUIAction.this.getModel();
                    uiModel.addValidatorResult(uiModel.getSelectedFishingOperation(), validationResult);
                    ((ValidateCruiseUIHandler)EditFishingOperationInValidationUIAction.this.getHandler()).updateCurrentOperationNode(validationResult);
                }
            }
        }
    };
    protected final BatchSavedListener batchSavedListener = new BatchSavedListener(){

        @Override
        public void onBatchSaved(BatchSavedEvent evt) {
            AbstractTuttiBatchUIModel model = evt.getSource();
            if (model.getFishingOperation() != null) {
                Cruise cruise = EditFishingOperationInValidationUIAction.this.getDataContext().reloadCruise();
                ((ValidateCruiseUIModel)EditFishingOperationInValidationUIAction.this.getModel()).setCruise(cruise);
                NuitonValidatorResult validationResult = EditFishingOperationInValidationUIAction.this.validationService.validateCruiseOperation(model.getFishingOperation());
                ValidateCruiseUIModel uiModel = (ValidateCruiseUIModel)EditFishingOperationInValidationUIAction.this.getModel();
                uiModel.addValidatorResult(uiModel.getSelectedFishingOperation(), validationResult);
                ((ValidateCruiseUIHandler)EditFishingOperationInValidationUIAction.this.getHandler()).updateCurrentOperationNode(validationResult);
            }
        }
    };

    public EditFishingOperationInValidationUIAction(ValidateCruiseUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n.t((String)"tutti.editFishingOperation.action.editFishingOperation.tip", (Object[])new Object[0]));
        this.validationService = this.getContext().getValidateCruiseOperationsService();
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public boolean prepareAction() throws Exception {
        this.removeListener();
        return super.prepareAction();
    }

    public void removeListener() {
        FishingOperationsUI operationPanel = ((ValidateCruiseUI)this.getUI()).getOperationPanel();
        operationPanel.getFishingOperationTabContent().getModel().removePropertyChangeListener(this.editFishingOperationModelListener);
        EditCatchesUI catchesTabContent = operationPanel.getCatchesTabContent();
        catchesTabContent.getModel().removePropertyChangeListener(this.editCatchesModelListener);
        catchesTabContent.getSpeciesTabContent().getHandler().removeBatchSavedListener(this.batchSavedListener);
        catchesTabContent.getBenthosTabContent().getHandler().removeBatchSavedListener(this.batchSavedListener);
        catchesTabContent.getAccidentalTabContent().getHandler().removeBatchSavedListener(this.batchSavedListener);
        catchesTabContent.getMarineLitterTabContent().getHandler().removeBatchSavedListener(this.batchSavedListener);
        catchesTabContent.getIndividualObservationTabContent().getHandler().removeBatchSavedListener(this.batchSavedListener);
    }

    @Override
    public void doAction() throws Exception {
        ((ValidateCruiseUI)this.getUI()).getOperationPanel().getModel().setSelectedFishingOperation(this.fishingOperation);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        FishingOperationsUI operationPanel = ((ValidateCruiseUI)this.getUI()).getOperationPanel();
        operationPanel.getFishingOperationTabContent().getModel().addPropertyChangeListener(this.editFishingOperationModelListener);
        EditCatchesUI catchesTabContent = operationPanel.getCatchesTabContent();
        catchesTabContent.getModel().addPropertyChangeListener(this.editCatchesModelListener);
        catchesTabContent.getSpeciesTabContent().getHandler().addBatchSavedListener(this.batchSavedListener);
        catchesTabContent.getBenthosTabContent().getHandler().addBatchSavedListener(this.batchSavedListener);
        catchesTabContent.getAccidentalTabContent().getHandler().addBatchSavedListener(this.batchSavedListener);
        catchesTabContent.getMarineLitterTabContent().getHandler().addBatchSavedListener(this.batchSavedListener);
        catchesTabContent.getIndividualObservationTabContent().getHandler().addBatchSavedListener(this.batchSavedListener);
    }

    public void releaseAction() {
        super.releaseAction();
        this.fishingOperation = null;
    }
}

